/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.jdk.utilities.runtimeinformation.MemoryInformation;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformation;
import com.atlassian.jdk.utilities.runtimeinformation.RuntimeInformationFactory;
import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraRuntimeInformationFactory {
    private static final Logger log = LoggerFactory.getLogger(JiraRuntimeInformationFactory.class);

    public static RuntimeInformation getRuntimeInformation() {
        return new SanitisedRuntimeInformation(RuntimeInformationFactory.getRuntimeInformation());
    }

    public static RuntimeInformation getRuntimeInformationInMegabytes() {
        return new MegaByteRuntimeInformation(JiraRuntimeInformationFactory.getRuntimeInformation());
    }

    @VisibleForTesting
    static class SanitisedRuntimeInformation
    implements RuntimeInformation {
        private static final Pattern PASSWORD_PATTERN = Pattern.compile("-D" + Pattern.quote("atlassian.recovery.password") + "\\s*=.*", 2);
        private final RuntimeInformation information;
        private final Supplier<List<String>> arguments;

        private SanitisedRuntimeInformation(RuntimeInformation information) {
            this(information, () -> ManagementFactory.getRuntimeMXBean().getInputArguments());
        }

        @VisibleForTesting
        SanitisedRuntimeInformation(RuntimeInformation information, Supplier<List<String>> arguments) {
            this.information = information;
            this.arguments = arguments;
        }

        public long getTotalHeapMemory() {
            return this.information.getTotalHeapMemory();
        }

        public long getTotalHeapMemoryUsed() {
            return this.information.getTotalHeapMemoryUsed();
        }

        public String getJvmInputArguments() {
            return this.arguments.get().stream().map(SanitisedRuntimeInformation::sanitiseArgument).collect(Collectors.joining(" "));
        }

        public List<MemoryInformation> getMemoryPoolInformation() {
            return this.information.getMemoryPoolInformation();
        }

        public long getTotalPermGenMemory() {
            return this.information.getTotalPermGenMemory();
        }

        public long getTotalPermGenMemoryUsed() {
            return this.information.getTotalPermGenMemoryUsed();
        }

        public long getTotalNonHeapMemory() {
            return this.information.getTotalNonHeapMemory();
        }

        public long getTotalNonHeapMemoryUsed() {
            return this.information.getTotalNonHeapMemoryUsed();
        }

        public long getXmx() {
            return this.information.getXmx();
        }

        public long getXms() {
            return this.information.getXms();
        }

        private static String sanitiseArgument(String argument) {
            if (argument != null && PASSWORD_PATTERN.matcher(argument).matches()) {
                return String.format("-D%s=****", "atlassian.recovery.password");
            }
            return argument;
        }
    }

    private static class MemoryInformationInMegabytes
    implements MemoryInformation {
        private static final int MEGABYTE = 0x100000;
        private final MemoryInformation info;

        public MemoryInformationInMegabytes(MemoryInformation info) {
            this.info = info;
        }

        public String getName() {
            return this.info.getName();
        }

        public long getTotal() {
            return Math.max(this.getUsed(), MemoryInformationInMegabytes.inMegabytes(this.info.getTotal()));
        }

        public long getUsed() {
            try {
                return MemoryInformationInMegabytes.inMegabytes(this.info.getUsed());
            }
            catch (RuntimeException e) {
                log.warn("Memory pool info returned by the java runtime is invalid for pool " + this.getName());
                log.debug(e.getMessage(), (Throwable)e);
                return -1L;
            }
        }

        public long getFree() {
            return this.getTotal() - this.getUsed();
        }

        private static long inMegabytes(double bytes) {
            return Math.round(bytes / 1048576.0);
        }
    }

    private static class MegaByteRuntimeInformation
    implements RuntimeInformation {
        private final RuntimeInformation info;

        public MegaByteRuntimeInformation(RuntimeInformation info) {
            this.info = info;
        }

        public long getTotalHeapMemory() {
            return this.info.getTotalHeapMemory();
        }

        public long getTotalHeapMemoryUsed() {
            return this.info.getTotalHeapMemoryUsed();
        }

        public String getJvmInputArguments() {
            return this.info.getJvmInputArguments();
        }

        public List<MemoryInformation> getMemoryPoolInformation() {
            return this.info.getMemoryPoolInformation().stream().map(MemoryInformationInMegabytes::new).collect(Collectors.toList());
        }

        public long getTotalPermGenMemory() {
            return this.info.getTotalPermGenMemory();
        }

        public long getTotalPermGenMemoryUsed() {
            return this.info.getTotalPermGenMemoryUsed();
        }

        public long getTotalNonHeapMemory() {
            return this.info.getTotalNonHeapMemory();
        }

        public long getTotalNonHeapMemoryUsed() {
            return this.info.getTotalNonHeapMemoryUsed();
        }

        public long getXmx() {
            return this.info.getXmx();
        }

        public long getXms() {
            return this.info.getXms();
        }
    }
}

