/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.DatabaseUtil;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import com.atlassian.jira.util.system.check.I18nMessage;
import com.atlassian.jira.util.system.check.SystemEnvironmentCheck;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JRA24857Check
implements SystemEnvironmentCheck {
    private static final Logger log = LoggerFactory.getLogger(JRA24857Check.class);
    private static final String ENGINE = "MyISAM";
    private final OfBizConnectionFactory factory;
    private final Supplier<HelpUrls> helpUrlsSupplier;
    private final DelegatorInterface delegatorInterface;

    @VisibleForTesting
    JRA24857Check(OfBizConnectionFactory factory, DelegatorInterface delegatorInterface, Supplier<HelpUrls> helpUrlsSupplier) {
        this.delegatorInterface = delegatorInterface;
        this.factory = Objects.requireNonNull(factory);
        this.helpUrlsSupplier = Objects.requireNonNull(helpUrlsSupplier);
    }

    public JRA24857Check() {
        this(DefaultOfBizConnectionFactory.getInstance(), (DelegatorInterface)ComponentAccessor.getComponent(DelegatorInterface.class), () -> (HelpUrls)ComponentAccessor.getComponent(HelpUrls.class));
    }

    public String getName() {
        return "MySQL MyISAM Check";
    }

    @Override
    public I18nMessage getWarningMessage() {
        Set<String> jiraTablesUsingMyISAM;
        if (this.isMySQL() && (!(jiraTablesUsingMyISAM = this.getJiraTablesUsingMyISAM()).isEmpty() || this.isSessionUsingMyISAM())) {
            return this.createWarning();
        }
        return null;
    }

    private Set<String> getJiraTablesUsingMyISAM() {
        Set<String> badTables = this.getMyISAMTables();
        badTables.retainAll(this.getJiraTables());
        return badTables;
    }

    @VisibleForTesting
    protected I18nMessage createWarning() {
        I18nMessage warning = new I18nMessage("admin.warning.JRA24857.syscheck");
        warning.setLink(this.helpUrlsSupplier.get().getUrl("JRA24857").getUrl());
        return warning;
    }

    @VisibleForTesting
    boolean isSessionUsingMyISAM() {
        return (Boolean)this.readSessionVariable("default_storage_engine").orElse(() -> this.readSessionVariable("storage_engine")).fold(() -> {
            log.warn("Unable to detect MySQL engine type. Assuming correct engine type.");
            return false;
        }, ENGINE::equalsIgnoreCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<String> readSessionVariable(String name) {
        Option option;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Option result;
            connection = this.factory.getConnection();
            statement = connection.createStatement(1003, 1007);
            resultSet = statement.executeQuery("SELECT @@" + name + " as engine");
            boolean found = resultSet.next();
            option = result = found ? Option.option((Object)StringUtils.trimToNull((String)resultSet.getString(1))) : Option.none();
        }
        catch (SQLException e) {
            Option option2;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to detect MySQL engine type.", (Throwable)e);
                }
                option2 = Option.none();
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeQuietly(resultSet);
                DatabaseUtil.closeQuietly(statement);
                DatabaseUtil.closeQuietly(connection);
                throw throwable;
            }
            DatabaseUtil.closeQuietly(resultSet);
            DatabaseUtil.closeQuietly(statement);
            DatabaseUtil.closeQuietly(connection);
            return option2;
        }
        DatabaseUtil.closeQuietly(resultSet);
        DatabaseUtil.closeQuietly(statement);
        DatabaseUtil.closeQuietly(connection);
        return option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Set<String> getMyISAMTables() {
        Set<String> set;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.factory.getConnection();
            String catalog = connection.getCatalog();
            statement = connection.prepareStatement("select TABLE_NAME from INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA = ? and engine = ?", 1003, 1007);
            statement.setString(1, catalog);
            statement.setString(2, ENGINE);
            resultSet = statement.executeQuery();
            Set<String> set2 = JRA24857Check.createTableSet();
            while (resultSet.next()) {
                set2.add(StringUtils.trimToNull((String)resultSet.getString(1)));
            }
            set = set2;
        }
        catch (SQLException e) {
            Set<String> set3;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Unable to read DB metadata from INFROMATION_SCHEMA.", (Throwable)e);
                } else {
                    log.warn("Unable to read DB metadata from INFROMATION_SCHEMA. Assuming correct MySQL engine.");
                }
                set3 = Collections.emptySet();
            }
            catch (Throwable throwable) {
                DatabaseUtil.closeQuietly(resultSet);
                DatabaseUtil.closeQuietly(statement);
                DatabaseUtil.closeQuietly(connection);
                throw throwable;
            }
            DatabaseUtil.closeQuietly(resultSet);
            DatabaseUtil.closeQuietly(statement);
            DatabaseUtil.closeQuietly(connection);
            return set3;
        }
        DatabaseUtil.closeQuietly(resultSet);
        DatabaseUtil.closeQuietly(statement);
        DatabaseUtil.closeQuietly(connection);
        return set;
    }

    @VisibleForTesting
    Set<String> getJiraTables() {
        ModelReader modelReader = this.delegatorInterface.getModelReader();
        try {
            Set<String> tables = JRA24857Check.createTableSet();
            for (String name : modelReader.getEntityNames()) {
                ModelEntity modelEntity = modelReader.getModelEntity(name);
                if (modelEntity instanceof ModelViewEntity) continue;
                tables.add(modelEntity.getPlainTableName());
            }
            return tables;
        }
        catch (GenericEntityException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to read DB configuration.", (Throwable)e);
            } else {
                log.warn("Unable to read DB configuration. Assuming correct MySQL engine.");
            }
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isMySQL() {
        Connection connection = null;
        try {
            connection = this.factory.getConnection();
            DatabaseMetaData dbMeta = connection.getMetaData();
            String productName = dbMeta.getDatabaseProductName();
            boolean bl = productName != null && productName.contains("MySQL");
            return bl;
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to detect database type.", (Throwable)e);
            } else {
                log.warn("Unable to detect database type. Assuming not MySQL.");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            DatabaseUtil.closeQuietly(connection);
        }
    }

    private static Set<String> createTableSet() {
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }
}

