/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileCleaningTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TempFileRemovingMultipartRequest {
    private static final Logger LOG = LoggerFactory.getLogger(TempFileRemovingMultipartRequest.class);
    private final int maxSize;
    private final Map<String, List<DiskFileItemWrapper>> files = new HashMap<String, List<DiskFileItemWrapper>>();
    private final Map<String, List<String>> params = new HashMap<String, List<String>>();
    private final HttpServletRequest originalRequest;
    private final String tempDirectory;
    private boolean alreadyParsed = false;
    private boolean cleaned = false;

    public TempFileRemovingMultipartRequest(HttpServletRequest servletRequest, String tempDirectory, int maxSize) {
        this.maxSize = maxSize;
        this.tempDirectory = tempDirectory;
        this.originalRequest = servletRequest;
    }

    public Collection<String> getFileParameterNames() {
        this.lazyParse();
        return this.files.keySet();
    }

    public String getContentType(String fieldName) {
        this.lazyParse();
        return this.files.getOrDefault(fieldName, Collections.emptyList()).stream().map(DiskFileItemWrapper::getContentType).findFirst().orElse(null);
    }

    public File getFile(String fieldName) {
        this.lazyParse();
        return this.files.getOrDefault(fieldName, Collections.emptyList()).stream().map(DiskFileItemWrapper::getFile).findFirst().orElse(Optional.empty()).orElse(null);
    }

    public String getFilesystemName(String fieldName) {
        this.lazyParse();
        return this.files.getOrDefault(fieldName, Collections.emptyList()).stream().map(DiskFileItemWrapper::getFilesystemName).findFirst().orElse(null);
    }

    public String getParameter(String name) {
        this.lazyParse();
        return this.params.getOrDefault(name, Collections.emptyList()).stream().findFirst().orElse(null);
    }

    public Collection<String> getParameterNames() {
        this.lazyParse();
        return this.params.keySet();
    }

    public List<String> getParameterValues(String name) {
        this.lazyParse();
        return this.params.getOrDefault(name, Collections.emptyList());
    }

    public void cleanUp() {
        this.files.forEach((fieldName, fileList) -> fileList.forEach(file -> {
            LOG.debug("Removing file {} {}", fieldName, (Object)file.getFilesystemName());
            file.delete();
        }));
        this.files.clear();
        this.params.clear();
        this.cleaned = true;
    }

    private void lazyParse() {
        if (!this.alreadyParsed && !this.cleaned) {
            this.alreadyParsed = true;
            this.parse(this.originalRequest, this.tempDirectory);
        }
    }

    private void parse(HttpServletRequest request, String saveDir) {
        try {
            this.processUpload(request, saveDir);
        }
        catch (FileUploadException e) {
            LOG.warn("Multipart file upload failed", (Throwable)e);
            this.cleanUp();
        }
        catch (Exception e) {
            LOG.warn("Unable to parse multipart request", (Throwable)e);
            this.cleanUp();
        }
    }

    private void processUpload(HttpServletRequest request, String saveDir) throws FileUploadException, UnsupportedEncodingException {
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            for (FileItem item : this.parseRequest(request, saveDir)) {
                LOG.debug("Found file item.");
                if (item.isFormField()) {
                    this.processNormalFormField(item, request.getCharacterEncoding());
                    continue;
                }
                this.processFileField(item);
            }
        }
    }

    @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME"}, justification="This is used just to check if a user has chosen any file in the browser.")
    private void processFileField(FileItem item) {
        LOG.debug("Item is a file upload");
        if (item.getName() == null || item.getName().trim().isEmpty()) {
            LOG.debug("No file has been uploaded for one of the fields.");
            return;
        }
        this.files.compute(item.getFieldName(), (key, oldValue) -> {
            List newValue = oldValue == null ? new ArrayList() : oldValue;
            newValue.add(DiskFileItemWrapper.getInstance((DiskFileItem)item, this.maxSize));
            return newValue;
        });
    }

    private void processNormalFormField(FileItem item, String charset) throws UnsupportedEncodingException {
        LOG.debug("Item is a normal form field");
        String toAdd = item.getSize() == 0L ? "" : (charset != null ? item.getString(charset) : item.getString());
        this.params.compute(item.getFieldName(), (key, oldValue) -> {
            List newValue = oldValue == null ? new ArrayList() : oldValue;
            newValue.add(toAdd);
            return newValue;
        });
        item.delete();
    }

    private List<FileItem> parseRequest(HttpServletRequest servletRequest, String saveDir) throws FileUploadException {
        DiskFileItemFactory fac = this.createDiskFileItemFactory(servletRequest.getServletContext(), saveDir);
        ServletFileUpload upload = this.createServletFileUpload(fac);
        return upload.parseRequest(this.createRequestContext(servletRequest));
    }

    private ServletFileUpload createServletFileUpload(DiskFileItemFactory fac) {
        return new ServletFileUpload((FileItemFactory)fac);
    }

    private DiskFileItemFactory createDiskFileItemFactory(ServletContext context, String saveDir) {
        FileCleaningTracker fileCleaningTracker = FileCleanerCleanup.getFileCleaningTracker((ServletContext)context);
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setFileCleaningTracker(fileCleaningTracker);
        fac.setSizeThreshold(-1);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        return fac;
    }

    private RequestContext createRequestContext(final HttpServletRequest req) {
        return new RequestContext(){

            public String getCharacterEncoding() {
                return req.getCharacterEncoding();
            }

            public String getContentType() {
                return req.getContentType();
            }

            public int getContentLength() {
                return req.getContentLength();
            }

            public InputStream getInputStream() throws IOException {
                ServletInputStream in = req.getInputStream();
                if (in == null) {
                    throw new IOException("Missing content in the request");
                }
                return in;
            }
        };
    }

    private static class DiskFileItemWrapper {
        private final DiskFileItem fileItem;
        private final boolean oversizeFile;

        public static DiskFileItemWrapper getInstance(DiskFileItem originalItem, long maxSize) {
            if (originalItem.getSize() > maxSize) {
                originalItem.delete();
                return new DiskFileItemWrapper(originalItem, true);
            }
            return new DiskFileItemWrapper(originalItem, false);
        }

        private DiskFileItemWrapper(DiskFileItem fileItem, boolean oversizeFile) {
            this.fileItem = fileItem;
            this.oversizeFile = oversizeFile;
        }

        public String getContentType() {
            return this.fileItem.getContentType();
        }

        public Optional<File> getFile() {
            return this.oversizeFile ? Optional.empty() : Optional.of(this.fileItem.getStoreLocation());
        }

        public String getFilesystemName() {
            return this.fileItem.getName();
        }

        public boolean isInMemory() {
            return this.fileItem.isInMemory();
        }

        public void delete() {
            if (!this.isInMemory()) {
                this.fileItem.delete();
            }
        }
    }
}

