/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.plugin.myjirahome.MyJiraHomeLinker;
import com.atlassian.jira.security.login.LoginManagerImpl;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.landingpage.LandingPageRedirector;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;

public class MyJiraHome
extends JiraWebActionSupport {
    private final MyJiraHomeLinker myJiraHomeLinker;
    private final UserManager userManager;
    private final LandingPageRedirector landingPageRedirector;

    public MyJiraHome(@Nonnull MyJiraHomeLinker myJiraHomeLinker, @Nonnull UserManager userManager, @Nonnull LandingPageRedirector landingPageRedirector) {
        this.myJiraHomeLinker = myJiraHomeLinker;
        this.userManager = userManager;
        this.landingPageRedirector = landingPageRedirector;
    }

    @SupportedMethods(value={RequestMethod.GET, RequestMethod.HEAD, RequestMethod.OPTIONS, RequestMethod.POST})
    protected String doExecute() throws Exception {
        return this.getRedirect(this.findMyHome());
    }

    private String findMyHome() {
        ApplicationUser loggedInUser = this.getLoggedInUser();
        Optional<String> redirectUrl = this.landingPageRedirector.redirectUrl(loggedInUser);
        if (redirectUrl.isPresent()) {
            return redirectUrl.get();
        }
        if (loggedInUser != null) {
            return this.myJiraHomeLinker.getHomeLink(loggedInUser);
        }
        if (this.isKnownButUnauthorised()) {
            return this.myJiraHomeLinker.getDefaultUserHome();
        }
        return this.myJiraHomeLinker.getHomeLink(null);
    }

    private boolean isKnownButUnauthorised() {
        String userKeyStr;
        ApplicationUser user;
        Object userKey;
        HttpServletRequest httpRequest = this.getHttpRequest();
        return Boolean.TRUE.equals(httpRequest.getAttribute(LoginManagerImpl.AUTHORISED_FAILURE)) && (userKey = httpRequest.getAttribute(LoginManagerImpl.AUTHORISING_USER_KEY)) instanceof String && (user = this.userManager.getUserByKey(userKeyStr = (String)userKey)) != null;
    }
}

