/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.admin.IntroductionProperty;
import com.atlassian.jira.avatar.GravatarSettings;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.config.DCFeatureLicenseChecker;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.setting.GzipCompression;
import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.util.HelpUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Iterables;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

@WebSudoRequired
public class ViewApplicationProperties
extends ProjectActionSupport {
    protected final UserSearchService searchService;
    protected final LocaleManager localeManager;
    protected final TimeZoneService timeZoneService;
    protected final RendererManager rendererManager;
    private final PluginAccessor pluginAccessor;
    private final GzipCompression gZipCompression;
    private final IntroductionProperty introductionProperty;
    private final FeatureManager featureManager;
    private final JiraLicenseService jiraLicenseService;
    protected final GravatarSettings gravatarSettings;
    protected final DCFeatureLicenseChecker licenseChecker;
    private boolean useGravatar;
    private String gravatarApiAddress;
    protected boolean disableInlineEdit;
    protected boolean criteriaAutoUpdate;
    private boolean productRecommendations;
    private boolean projectDescriptionHtmlEnabled;
    private boolean customFieldHtmlEnabled;
    private boolean emptyJqlReturnsNoDataEnabled;
    private boolean csvExportDialogEnabled;
    private boolean xsrfDialogDisplayParamsEnabled;
    private boolean issueCommentReactionsEnabled;

    public ViewApplicationProperties(UserSearchService searchService, LocaleManager localeManager, TimeZoneService timeZoneService, RendererManager rendererManager, PluginAccessor pluginAccessor, GzipCompression gZipCompression, FeatureManager featureManager, IntroductionProperty introductionProperty, JiraLicenseService jiraLicenseService, GravatarSettings gravatarSettings, DCFeatureLicenseChecker licenseChecker) {
        this.searchService = searchService;
        this.localeManager = localeManager;
        this.timeZoneService = timeZoneService;
        this.rendererManager = rendererManager;
        this.pluginAccessor = pluginAccessor;
        this.gZipCompression = gZipCompression;
        this.featureManager = featureManager;
        this.introductionProperty = introductionProperty;
        this.jiraLicenseService = jiraLicenseService;
        this.gravatarSettings = gravatarSettings;
        this.licenseChecker = licenseChecker;
        this.useGravatar = gravatarSettings.isAllowGravatars();
        this.gravatarApiAddress = gravatarSettings.getCustomApiAddress();
        this.disableInlineEdit = this.getApplicationProperties().getOption("jira.issue.inline.edit.disabled");
        this.criteriaAutoUpdate = this.getApplicationProperties().getOption("jira.issuenav.criteria.autoupdate");
        this.productRecommendations = false;
        this.projectDescriptionHtmlEnabled = this.getApplicationProperties().getOption("jira.project.description.html.enabled");
        this.customFieldHtmlEnabled = this.getApplicationProperties().getOption("jira.custom.field.html.enabled");
        this.emptyJqlReturnsNoDataEnabled = this.getApplicationProperties().getOption("jira.empty.jql.returns.no.data.enabled");
        this.csvExportDialogEnabled = this.getApplicationProperties().getOption("jira.csv.export.dialog.enabled");
        this.xsrfDialogDisplayParamsEnabled = this.getApplicationProperties().getOption("jira.xsrf.dialog.display.url.params.enabled");
        this.issueCommentReactionsEnabled = this.getApplicationProperties().getOption("jira.issue.view.comment.reactions.enabled");
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public String getJiraMode() {
        StringBuilder i18nString = new StringBuilder("admin.jira.mode.").append(this.getApplicationProperties().getString("jira.mode"));
        return this.getText(i18nString.toString());
    }

    public String getDisplayNameOfLocale(Locale locale) {
        return locale.getDisplayName(this.getLocale());
    }

    public boolean useSystemTimeZone() {
        return this.timeZoneService.useSystemTimeZone();
    }

    public TimeZoneInfo getDefaultTimeZoneInfo() {
        return this.timeZoneService.getDefaultTimeZoneInfo(this.getJiraServiceContext());
    }

    public boolean isUseGravatar() {
        return this.useGravatar;
    }

    public void setUseGravatar(boolean useGravatar) {
        this.useGravatar = useGravatar;
    }

    public String getGravatarApiAddress() {
        return this.gravatarApiAddress;
    }

    public void setGravatarApiAddress(String gravatarApiAddress) {
        this.gravatarApiAddress = gravatarApiAddress;
    }

    public String getContactAdministratorsMessage() {
        String message = this.getApplicationProperties().getDefaultBackedString("jira.contact.administrators.message");
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer").render(message, null);
    }

    public boolean getShowPluginHints() {
        return this.getApplicationProperties().getOption("show.plugin.marketing.hints");
    }

    public String getTacUrl() {
        return HelpUtil.getInstance().getHelpPath("application.properties.server.language.from.tac").getUrl();
    }

    public boolean isDisableInlineEdit() {
        return this.disableInlineEdit;
    }

    public boolean isShowDisableInlineEdit() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.jira.jira-issue-nav-plugin");
    }

    public boolean isShowDisableCriteriaAutoUpdate() {
        return this.pluginAccessor.isPluginEnabled("com.atlassian.jira.jira-issue-nav-plugin");
    }

    public boolean isCriteriaAutoUpdate() {
        return this.criteriaAutoUpdate;
    }

    public final boolean isProductRecommendationsEditable() {
        return this.areThereEvaluationLicenses();
    }

    public final boolean isProductRecommendations() {
        return this.productRecommendations;
    }

    public void setProductRecommendations(boolean productRecommendations) {
        this.productRecommendations = productRecommendations;
    }

    public boolean isProjectDescriptionHtmlEnabled() {
        return this.projectDescriptionHtmlEnabled;
    }

    public void setProjectDescriptionHtmlEnabled(boolean projectDescriptionHtmlEnabled) {
        this.projectDescriptionHtmlEnabled = projectDescriptionHtmlEnabled;
    }

    public boolean isCustomFieldHtmlEnabled() {
        return this.customFieldHtmlEnabled;
    }

    public void setCustomFieldHtmlEnabled(boolean customFieldHtmlEnabled) {
        this.customFieldHtmlEnabled = customFieldHtmlEnabled;
    }

    public GzipCompression getGzipCompression() {
        return this.gZipCompression;
    }

    public IntroductionProperty getIntroductionProperty() {
        return this.introductionProperty;
    }

    public boolean isBackgroundIndexingAvailable() {
        return true;
    }

    private boolean areThereEvaluationLicenses() {
        return Iterables.any((Iterable)this.jiraLicenseService.getLicenses(), l -> l.isEvaluation());
    }

    public boolean getIsDataCenterLicensed() {
        return this.jiraLicenseService.isDataCenterLicensed();
    }

    public boolean isEmptyJqlReturnsNoDataEnabled() {
        return this.emptyJqlReturnsNoDataEnabled;
    }

    public void setEmptyJqlReturnsNoDataEnabled(boolean emptyJqlReturnsNoDataEnabled) {
        this.emptyJqlReturnsNoDataEnabled = emptyJqlReturnsNoDataEnabled;
    }

    public boolean isCsvExportDialogEnabled() {
        return this.csvExportDialogEnabled;
    }

    public void setCsvExportDialogEnabled(boolean csvExportDialogEnabled) {
        this.csvExportDialogEnabled = csvExportDialogEnabled;
    }

    public boolean isXsrfDialogDisplayParamsEnabled() {
        return this.xsrfDialogDisplayParamsEnabled;
    }

    public void setXsrfDialogDisplayParamsEnabled(boolean xsrfDialogDisplayParamsEnabled) {
        this.xsrfDialogDisplayParamsEnabled = xsrfDialogDisplayParamsEnabled;
    }

    public boolean isIssueCommentReactionsEnabled() {
        return this.issueCommentReactionsEnabled;
    }

    public void setIssueCommentReactionsEnabled(boolean issueCommentReactionsEnabled) {
        this.issueCommentReactionsEnabled = issueCommentReactionsEnabled;
    }

    public Map<String, String> getAllowedLanguages() {
        LinkedHashMap<String, String> allowedLanguages = new LinkedHashMap<String, String>();
        allowedLanguages.put("armenian", this.getText("admin.jira.allowed.language.armenian"));
        allowedLanguages.put("basque", this.getText("admin.jira.allowed.language.basque"));
        allowedLanguages.put("brazilian", this.getText("admin.jira.allowed.language.brazilian"));
        allowedLanguages.put("bulgarian", this.getText("admin.jira.allowed.language.bulgarian"));
        allowedLanguages.put("catalan", this.getText("admin.jira.allowed.language.catalan"));
        allowedLanguages.put("chinese", this.getText("admin.jira.allowed.language.chinese"));
        allowedLanguages.put("cjk", this.getText("admin.jira.allowed.language.cjk"));
        allowedLanguages.put("czech", this.getText("admin.jira.allowed.language.czech"));
        allowedLanguages.put("danish", this.getText("admin.jira.allowed.language.danish"));
        allowedLanguages.put("dutch", this.getText("admin.jira.allowed.language.dutch"));
        allowedLanguages.put("english", this.getText("admin.jira.allowed.language.english.aggressive.stemming"));
        allowedLanguages.put("english-moderate-stemming", this.getText("admin.jira.allowed.language.english.moderate.stemming"));
        allowedLanguages.put("english-minimal-stemming", this.getText("admin.jira.allowed.language.english.minimal.stemming"));
        allowedLanguages.put("finnish", this.getText("admin.jira.allowed.language.finnish"));
        allowedLanguages.put("french", this.getText("admin.jira.allowed.language.french"));
        allowedLanguages.put("german", this.getText("admin.jira.allowed.language.german"));
        allowedLanguages.put("greek", this.getText("admin.jira.allowed.language.greek"));
        allowedLanguages.put("hungarian", this.getText("admin.jira.allowed.language.hungarian"));
        allowedLanguages.put("italian", this.getText("admin.jira.allowed.language.italian"));
        allowedLanguages.put("norwegian", this.getText("admin.jira.allowed.language.norwegian"));
        allowedLanguages.put("portuguese", this.getText("admin.jira.allowed.language.portuguese"));
        allowedLanguages.put("romanian", this.getText("admin.jira.allowed.language.romanian"));
        allowedLanguages.put("russian", this.getText("admin.jira.allowed.language.russian"));
        allowedLanguages.put("spanish", this.getText("admin.jira.allowed.language.spanish"));
        allowedLanguages.put("swedish", this.getText("admin.jira.allowed.language.swedish"));
        allowedLanguages.put("thai", this.getText("admin.jira.allowed.language.thai"));
        allowedLanguages.put("other", this.getText("admin.jira.allowed.language.other"));
        return allowedLanguages;
    }

    public String getCurrentIndexingLanguageDescription() {
        return this.getAllowedLanguages().get(this.getApplicationProperties().getString("jira.i18n.language.index"));
    }

    public boolean isUnifiedUserManagementEnabled() {
        return this.featureManager.isEnabled("unified.usermanagement");
    }

    public boolean getCommentReactionsEnabled() {
        return this.licenseChecker.isEnabled(JiraFeatureFlagRegistrar.COMMENT_REACTIONS);
    }

    public boolean isStackTraceEnabled() {
        return this.getApplicationProperties().getOption("jira.option.stacktraceOnErrorpage");
    }
}

