/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.customfields;

import com.atlassian.jira.admin.RenderableProperty;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldDescription;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.translation.TranslationManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class TranslateCustomField
extends JiraWebActionSupport {
    private Long id;
    private String name;
    private String description;
    private String selectedLocale;
    private final CustomFieldManager customFieldManager;
    private final CustomFieldService customFieldService;
    private final ManagedConfigurationItemService managedConfigurationItemService;
    private final LocaleManager localeManager;
    private final TranslationManager translationManager;
    private final CustomFieldDescription customFieldDescription;

    public TranslateCustomField(CustomFieldService customFieldService, CustomFieldManager customFieldManager, ManagedConfigurationItemService managedConfigurationItemService, LocaleManager localeManager, TranslationManager translationManager, CustomFieldDescription customFieldDescription) {
        this.customFieldService = customFieldService;
        this.customFieldManager = customFieldManager;
        this.managedConfigurationItemService = managedConfigurationItemService;
        this.localeManager = localeManager;
        this.translationManager = translationManager;
        this.customFieldDescription = customFieldDescription;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (!this.validateFieldLocked()) {
            return "error";
        }
        Locale locale = StringUtils.isNotEmpty((CharSequence)this.getSelectedLocale()) ? this.localeManager.getLocale(this.getSelectedLocale()) : this.getLocale();
        if (locale != null) {
            this.setName(this.translationManager.getCustomFieldNameTranslation(this.getCustomField(), locale));
            this.setDescription(this.translationManager.getCustomFieldDescriptionTranslation(this.getCustomField(), locale));
            this.setSelectedLocale(locale.toString());
        }
        return "input";
    }

    protected void doValidation() {
        if (!this.validateFieldLocked()) {
            return;
        }
        this.customFieldService.validateTranslation(this.getJiraServiceContext(), this.id, this.name, this.description, this.getSelectedLocale());
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.customFieldService.updateTranslation(this.getJiraServiceContext(), this.id, this.name, this.description, this.getSelectedLocale());
        return this.getRedirect("TranslateCustomField!default.jspa?id=" + this.getId() + "&selectedLocale=" + this.getSelectedLocale());
    }

    public boolean isFieldLocked() {
        return !this.managedConfigurationItemService.doesUserHavePermission(this.getLoggedInUser(), this.getManagedConfigurationEntity());
    }

    private boolean validateFieldLocked() {
        if (this.isFieldLocked()) {
            this.addErrorMessage(this.getText("admin.managed.configuration.items.customfield.error.cannot.edit.locked", this.getCustomField().getName()));
            return false;
        }
        return true;
    }

    private ManagedConfigurationItem getManagedConfigurationEntity() {
        CustomField customField = this.getCustomField();
        if (customField == null) {
            return null;
        }
        return this.managedConfigurationItemService.getManagedCustomField(customField);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long l) {
        this.id = l;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RenderableProperty getDescriptionProperty() {
        return this.customFieldDescription.createRenderablePropertyFor(this.getDescription());
    }

    public String getSelectedLocale() {
        return this.selectedLocale;
    }

    public void setSelectedLocale(String selectedLocale) {
        this.selectedLocale = selectedLocale;
    }

    public Map getInstalledLocales() {
        return this.translationManager.getInstalledLocales();
    }

    public CustomField getCustomField() {
        return this.customFieldManager.getCustomFieldObject(this.getId());
    }
}

