/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields;

import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemService;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.ProjectFieldLayoutSchemeHelper;
import com.atlassian.jira.issue.fields.layout.field.EditableDefaultFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.web.action.admin.issuefields.AbstractConfigureFieldLayout;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;

@WebSudoRequired
public class ViewIssueFields
extends AbstractConfigureFieldLayout {
    private final ProjectFieldLayoutSchemeHelper helper;
    private EditableDefaultFieldLayout editableDefaultFieldLayout;
    private List<Project> projects;

    public ViewIssueFields(FieldScreenManager fieldScreenManager, RendererManager rendererManager, ReindexMessageManager reindexMessageManager, FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, FieldLayoutSchemeHelper fieldLayoutSchemeHelper, HackyFieldRendererRegistry hackyFieldRendererRegistry, ProjectFieldLayoutSchemeHelper helper, ManagedConfigurationItemService managedConfigurationItemService) {
        super(fieldScreenManager, rendererManager, reindexMessageManager, fieldLayoutSchemeHelper, fieldManager, fieldLayoutManager, hackyFieldRendererRegistry, managedConfigurationItemService);
        this.helper = helper;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    @Override
    public EditableFieldLayout getFieldLayout() {
        if (this.editableDefaultFieldLayout == null) {
            try {
                this.editableDefaultFieldLayout = this.getFieldLayoutManager().getEditableDefaultFieldLayout();
            }
            catch (DataAccessException e) {
                this.log.error((Object)"Error while retrieving field layout.", (Throwable)e);
                this.addErrorMessage(this.getText("view.issue.error.retrieving.field.layout"));
            }
        }
        return this.editableDefaultFieldLayout;
    }

    @Override
    protected String getFieldRedirect() throws Exception {
        return this.getRedirect("ViewIssueFields.jspa");
    }

    @Override
    protected void store() {
        try {
            this.getFieldLayoutManager().storeEditableDefaultFieldLayout((EditableDefaultFieldLayout)this.getFieldLayout());
        }
        catch (DataAccessException e) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.error.storing"));
        }
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            FieldLayout fieldLayout = this.getFieldLayoutManager().getFieldLayout();
            this.projects = this.helper.getProjectsForFieldLayout(fieldLayout);
        }
        return this.projects;
    }
}

