/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.AbstractFieldLayoutAction;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Iterator;

@WebSudoRequired
public class EditFieldLayout
extends AbstractFieldLayoutAction {
    public EditFieldLayout(FieldLayoutManager fieldLayoutManager) {
        super(fieldLayoutManager);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayout();
            if (!this.invalidInput()) {
                this.setFieldLayoutName(this.getFieldLayout().getName());
                this.setFieldLayoutDescription(this.getFieldLayout().getDescription());
            }
        }
        if (!this.invalidInput()) {
            return "input";
        }
        return "error";
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput()) {
            this.validateFieldLayout();
            if (!this.invalidInput()) {
                this.validateName();
                if (!this.invalidInput()) {
                    Iterator<EditableFieldLayout> iterator = this.getFieldLayouts().iterator();
                    while (iterator.hasNext()) {
                        EditableFieldLayout editableFieldLayout;
                        EditableFieldLayout fieldLayout = editableFieldLayout = iterator.next();
                        if (this.getId().equals(fieldLayout.getId()) || !this.getFieldLayoutName().equals(fieldLayout.getName())) continue;
                        this.addError("fieldLayoutName", this.getText("admin.errors.fieldlayout.name.exists"));
                    }
                }
            }
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        this.getFieldLayout().setName(this.getFieldLayoutName());
        this.getFieldLayout().setDescription(this.getFieldLayoutDescription());
        this.getFieldLayoutManager().storeEditableFieldLayout(this.getFieldLayout());
        return this.redirectToView();
    }
}

