/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens.enterprise;

import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
public class SelectIssueTypeScreenScheme
extends JiraWebActionSupport {
    private final ProjectManager projectManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private Long projectId;
    private Long schemeId;
    private Collection issueTypeScreenSchemes;

    public SelectIssueTypeScreenScheme(ProjectManager projectManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager) {
        this.projectManager = projectManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.validateId();
        if (!this.invalidInput()) {
            IssueTypeScreenScheme issueTypeScreenScheme = this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(this.getProject());
            if (issueTypeScreenScheme != null) {
                this.setSchemeId(issueTypeScreenScheme.getId());
            } else {
                this.setSchemeId(null);
            }
        }
        return "input";
    }

    protected void doValidation() {
        this.validateId();
        if (!this.invalidInput() && this.getSchemeId() != null && this.getFieldLayoutScheme() == null) {
            this.addError("schemeId", this.getText("admin.errors.screens.invalid.scheme.id"));
        }
    }

    private void validateId() {
        if (this.getProjectId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.cannot.be.null"));
        } else if (this.getProject() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayout.invalid.id2"));
        }
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (this.getSchemeId() != null) {
            this.issueTypeScreenSchemeManager.addSchemeAssociation(this.getProject(), this.getFieldLayoutScheme());
        }
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProject().getKey() + "/screens");
    }

    private IssueTypeScreenScheme getFieldLayoutScheme() {
        return this.issueTypeScreenSchemeManager.getIssueTypeScreenScheme(this.getSchemeId());
    }

    public Project getProject() {
        return this.projectManager.getProjectObj(this.getProjectId());
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public Collection getIssueTypeScreenSchemes() {
        if (this.issueTypeScreenSchemes == null) {
            this.issueTypeScreenSchemes = this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes();
        }
        return this.issueTypeScreenSchemes;
    }
}

