/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.PrioritySchemeService;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.admin.priorities.AbstractManagePrioritiesAction;
import com.atlassian.jira.web.action.admin.priorities.PriorityManageableOption;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class DeletePriorityScheme
extends AbstractManagePrioritiesAction {
    public DeletePriorityScheme(FieldConfigSchemeManager configSchemeManager, FieldManager fieldManager, PriorityManageableOption priorityManageableOption, PrioritySchemeManager prioritySchemeManager, PrioritySchemeService prioritySchemeService) {
        super(configSchemeManager, fieldManager, priorityManageableOption, prioritySchemeManager, prioritySchemeService);
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        return super.doDefault();
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        FieldConfigScheme scheme = this.getPrioritySchemeManager().getScheme(this.getSchemeId());
        if (scheme != null) {
            ServiceResult serviceResult = this.prioritySchemeService.deleteScheme(this.getLoggedInUser(), scheme);
            this.addErrorCollection(serviceResult.getErrorCollection());
        }
        return this.returnCompleteWithInlineRedirect("ViewPrioritySchemes.jspa");
    }

    @ActionViewDataMappings(value={"input", "error"})
    public Map<String, Object> getSoyData() {
        FieldConfigScheme scheme = this.getPrioritySchemeManager().getScheme(this.getSchemeId());
        ImmutableMap.Builder data = new ImmutableMap.Builder().put((Object)"xsrfToken", (Object)StringUtils.defaultIfBlank((CharSequence)this.getXsrfToken(), (CharSequence)"")).put((Object)"globalErrors", (Object)this.getErrorMessages()).put((Object)"priorityScheme", (Object)scheme).put((Object)"prioritySchemeProjects", (Object)scheme.getAssociatedProjectObjects());
        return data.build();
    }
}

