/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.workflow;

import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.workflow.WorkflowViewMode;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class EditWorkflowDispatcher
extends JiraWebActionSupport {
    private String wfName;
    private Long project;
    private String issueType;
    private final WorkflowService workflowService;

    public EditWorkflowDispatcher(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() {
        JiraWorkflow workflow = this.workflowService.getWorkflow(this.getJiraServiceContext(), this.getWfName());
        if (this.hasAnyErrors() || workflow == null) {
            return "error";
        }
        if (workflow.isSystemWorkflow()) {
            UrlBuilder builder = new UrlBuilder("ViewWorkflowSteps.jspa").addParameter("workflowMode", "live").addParameter("workflowName", workflow.getName());
            return this.getRedirect(builder.asUrlString());
        }
        if (!workflow.isActive()) {
            return this.redirectToEdit(workflow);
        }
        workflow = !workflow.hasDraftWorkflow() ? this.workflowService.createDraftWorkflow(this.getJiraServiceContext(), workflow.getName()) : this.workflowService.getDraftWorkflow(this.getJiraServiceContext(), workflow.getName());
        if (this.hasAnyErrors() || workflow == null) {
            return "error";
        }
        return this.redirectToEdit(workflow);
    }

    private String redirectToEdit(JiraWorkflow workflow) {
        String mode = workflow.isDraftWorkflow() ? "draft" : "live";
        UrlBuilder builder = WorkflowViewMode.parseFromAction(this) == WorkflowViewMode.DIAGRAM ? new UrlBuilder("WorkflowDesigner.jspa").addParameter("workflowMode", mode).addParameter("wfName", workflow.getName()) : new UrlBuilder("ViewWorkflowSteps.jspa").addParameter("workflowMode", mode).addParameter("workflowName", workflow.getName());
        if (this.getProject() != null) {
            builder.addParameter("project", (Object)this.getProject());
        }
        if (this.getIssueType() != null) {
            builder.addParameter("issueType", this.getIssueType());
        }
        return this.getRedirect(builder.asUrlString());
    }

    public String getWfName() {
        return this.wfName;
    }

    public void setWfName(String wfName) {
        this.wfName = wfName;
    }

    public Long getProject() {
        return this.project;
    }

    public void setProject(Long project) {
        this.project = project;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public void setIssueType(String issueType) {
        this.issueType = StringUtils.stripToNull((String)issueType);
    }
}

