/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.filter.FilterDeletionWarningViewProvider;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.filter.AbstractFilterAction;

public class DeleteFilter
extends AbstractFilterAction {
    private final SearchRequestService searchRequestService;
    private FilterDeletionWarningViewProvider filterDeletionWarningViewProvider;

    public DeleteFilter(IssueSearcherManager issueSearcherManager, SearchRequestService searchRequestService, SearchService searchService, FilterDeletionWarningViewProvider filterDeletionWarningViewProvider) {
        super(issueSearcherManager, searchService);
        this.searchRequestService = searchRequestService;
        this.filterDeletionWarningViewProvider = filterDeletionWarningViewProvider;
    }

    public boolean canDelete() {
        return !this.hasAnyErrors();
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.getFilterId() != null) {
            this.searchRequestService.validateForDelete(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        JiraServiceContext ctx = this.getJiraServiceContext();
        if (this.getFilterId() != null) {
            this.searchRequestService.validateForDelete(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
            this.searchRequestService.deleteFilter(ctx, this.getFilterId());
            if (this.hasAnyErrors()) {
                return "error";
            }
        } else {
            this.addErrorMessage(this.getText("admin.errors.filters.cannot.delete.filter"));
            return "error";
        }
        this.setSearchRequest(null);
        return this.returnComplete(this.getReturnUrl());
    }

    public String getWarningHtml() {
        return this.filterDeletionWarningViewProvider.getWarningHtml(this.getFilter());
    }
}

