/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.filter;

import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;

public class FilterSubscriptionWarningContextProvider
implements ContextProvider {
    @VisibleForTesting
    static final String CONTEXT_KEY_SUBSCRIPTION_COUNT = "subscriptionCount";
    @VisibleForTesting
    static final String CONTEXT_KEY_SUBSCRIPTION_PAGE_URL = "subscriptionPageUrl";
    private final FilterSubscriptionService subscriptionService;
    private final SearchRequestManager searchRequestManager;

    public FilterSubscriptionWarningContextProvider(FilterSubscriptionService subscriptionService, SearchRequestManager searchRequestManager) {
        this.subscriptionService = subscriptionService;
        this.searchRequestManager = searchRequestManager;
    }

    public void init(Map<String, String> map) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> map) {
        SearchRequest searchRequest = (SearchRequest)map.get("searchRequest");
        map.put(CONTEXT_KEY_SUBSCRIPTION_COUNT, this.getSubscriptionCount(searchRequest));
        map.put(CONTEXT_KEY_SUBSCRIPTION_PAGE_URL, this.getManageSubscriptionsLink(searchRequest));
        return map;
    }

    private int getSubscriptionCount(SearchRequest searchRequest) {
        ApplicationUser filterOwner = this.searchRequestManager.getSearchRequestOwner(searchRequest.getId());
        return this.subscriptionService.getVisibleFilterSubscriptions(filterOwner, searchRequest).size();
    }

    private String getManageSubscriptionsLink(SearchRequest searchRequest) {
        return "/secure/ViewSubscriptions.jspa?filterId=" + searchRequest.getId();
    }
}

