/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.mau.MauEventService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.CreateIssue;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CreateIssueDetails
extends CreateIssue {
    protected final IssueService issueService;
    protected IssueService.CreateValidationResult validationResult;
    private final TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator;

    public CreateIssueDetails(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean, IssueService issueService, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator) {
        super(issueFactory, issueCreationHelperBean);
        this.issueService = issueService;
        this.temporaryAttachmentsMonitorLocator = temporaryAttachmentsMonitorLocator;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doInit() {
        if (this.isAbleToCreateIssueInSelectedProject()) {
            this.doValidation();
            if (this.invalidInput()) {
                return "error";
            }
        }
        return "input";
    }

    @Override
    protected void doValidation() {
        this.validationResult = this.issueService.validateCreate(this.getLoggedInUser(), (IssueInputParameters)new IssueInputParametersImpl(ActionContext.getParameters()));
        this.setIssueObject((Issue)this.validationResult.getIssue());
        this.fieldValuesHolder = this.validationResult.getFieldValuesHolder();
        if (!this.validationResult.isValid()) {
            ErrorCollection errorCollection = this.validationResult.getErrorCollection();
            this.transferErrorToMessages(errorCollection);
            this.addErrorCollection(errorCollection);
        }
    }

    protected void transferErrorToMessages(ErrorCollection errorCollection) {
        for (Map.Entry entry : errorCollection.getErrors().entrySet()) {
            errorCollection.addErrorMessage((String)entry.getKey() + ": " + (String)entry.getValue());
        }
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.GET, RequestMethod.POST})
    protected String doExecute() throws Exception {
        try {
            this.createIssue();
            if (this.hasAnyErrors()) {
                String string = "error";
                return string;
            }
            String string = this.doPostCreationTasks();
            return string;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            this.addErrorMessage(e.getMessage() != null ? e.getMessage() : ExceptionUtils.getStackTrace((Throwable)e));
            String string = "error";
            return string;
        }
        finally {
            ((MauEventService)ComponentAccessor.getComponent(MauEventService.class)).setApplicationForThreadBasedOnProject(this.getProject());
        }
    }

    protected void createIssue() throws Exception {
        IssueService.IssueResult issueResult;
        if (this.validationResult == null) {
            this.validationResult = new IssueService.CreateValidationResult(this.getIssueObject(), (ErrorCollection)new SimpleErrorCollection(), this.getFieldValuesHolder(), Collections.emptyMap());
        }
        if ((issueResult = this.issueService.create(this.getLoggedInUser(), this.validationResult, this.getAuxiliarySubmitButtonValue())).isValid()) {
            this.setIssueObject((Issue)issueResult.getIssue());
            TemporaryAttachmentsMonitor temporaryAttachmentsMonitor = this.temporaryAttachmentsMonitorLocator.get(false);
            if (temporaryAttachmentsMonitor != null) {
                temporaryAttachmentsMonitor.clearEntriesForFormToken(this.getFormToken());
            }
        } else {
            ErrorCollection errorCollection = issueResult.getErrorCollection();
            this.transferErrorToMessages(errorCollection);
            this.addErrorCollection(errorCollection);
        }
    }

    protected String doPostCreationTasks() throws Exception {
        String issueKey = JiraUrlCodec.encode((String)this.getKey());
        if (this.isIssueValid()) {
            return this.getRedirect("/browse/" + issueKey);
        }
        this.errorMessages.clear();
        return this.getRedirect("CantBrowseCreatedIssue.jspa?issueKey=" + issueKey);
    }

    @Override
    public GenericValue getIssue() {
        GenericValue issue = super.getIssue();
        if (issue == null) {
            throw new IllegalStateException("No issue has been created yet so it can not be retrieved");
        }
        return issue;
    }

    protected String getAuxiliarySubmitButtonValue() throws WorkflowException {
        JiraWorkflow workflow = ComponentAccessor.getWorkflowManager().getWorkflow(this.getPid(), this.getIssuetype());
        if (workflow == null) {
            throw new WorkflowException("No workflow for pid " + this.getPid() + ", issuetype " + this.getIssuetype());
        }
        WorkflowDescriptor descriptor = workflow.getDescriptor();
        List initialActions = descriptor.getInitialActions();
        if (initialActions.size() == 0) {
            throw new WorkflowException("There are no initial actions for workflow " + workflow + ", descriptor " + descriptor + " associated with pid " + this.getPid() + " and issue type " + this.getIssuetype());
        }
        Map buttons = ((ActionDescriptor)initialActions.get(0)).getMetaAttributes();
        for (String key : buttons.keySet()) {
            if (this.request.getParameter(key) == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public Map<String, Object> getDisplayParams() {
        HashMap<String, Object> displayParams = new HashMap<String, Object>();
        displayParams.put("theme", "aui");
        return displayParams;
    }
}

