/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.TemporaryAttachmentsMonitorLocator;
import com.atlassian.jira.issue.issuetype.IssueTypeId;
import com.atlassian.jira.user.UserIssueTypeManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.issue.CreateIssueDetails;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.opensymphony.util.TextUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class CreateSubTaskIssueDetails
extends CreateIssueDetails {
    public static final String SUB_TASK_LINK_TYPE_NAME = "jira_subtask_link";
    public static final String SUB_TASK_LINK_TYPE_STYLE = "jira_subtask";
    public static final String SUB_TASK_LINK_TYPE_INWARD_NAME = "jira_subtask_inward";
    public static final String SUB_TASK_LINK_TYPE_OUTWARD_NAME = "jira_subtask_outward";
    private final SubTaskManager subTaskManager;
    private final IssueService issueService;
    private final UserIssueTypeManager userIssueTypeManager;
    private Long parentIssueId;
    private boolean requiresLogin;

    public CreateSubTaskIssueDetails(SubTaskManager subTaskManager, IssueCreationHelperBean issueCreationHelperBean, IssueFactory issueFactory, IssueService issueService, TemporaryAttachmentsMonitorLocator temporaryAttachmentsMonitorLocator, UserIssueTypeManager userIssueTypeManager) {
        super(issueFactory, issueCreationHelperBean, issueService, temporaryAttachmentsMonitorLocator);
        this.subTaskManager = subTaskManager;
        this.issueService = issueService;
        this.userIssueTypeManager = userIssueTypeManager;
        this.getIgnoreFieldIds().add("security");
    }

    @Override
    protected void doValidation() {
        Long parentIssueId = this.getParentIssueId();
        if (parentIssueId == null) {
            this.addErrorMessage(this.getText("admin.errors.issues.parent.issue.id.not.set"));
            return;
        }
        MutableIssue parent = this.getIssueManager().getIssueObject(parentIssueId);
        if (parent != null && !parent.isEditable()) {
            this.addErrorMessage(this.getText("admin.errors.issues.parent.issue.not.editable"));
        }
        IssueInputParameters issueInputParameters = this.issueService.newIssueInputParameters(ActionContext.getParameters());
        this.validationResult = this.issueService.validateSubTaskCreate(this.getLoggedInUser(), this.getParentIssueId(), issueInputParameters);
        if (!this.validationResult.isValid()) {
            ErrorCollection errorCollection = this.validationResult.getErrorCollection();
            this.transferErrorToMessages(errorCollection);
            this.addErrorCollection(errorCollection);
        } else {
            this.getIssueObject().setParentId(this.getParentIssueId());
            this.getIssueObject().setProjectId(this.getPid());
            this.getIssueObject().setIssueTypeId(this.getIssuetype());
        }
        this.fieldValuesHolder = this.validationResult.getFieldValuesHolder();
        this.setIssueObject((Issue)this.validationResult.getIssue());
        if (this.getReasons() != null && this.getReasons().contains(ErrorCollection.Reason.NOT_LOGGED_IN)) {
            this.requiresLogin = true;
        }
    }

    @Override
    protected String doPostCreationTasks() throws Exception {
        if (this.invalidInput()) {
            return this.getResult();
        }
        this.createSubTaskLink();
        this.recordHistoryIssueType();
        if (TextUtils.stringSet((String)this.getViewIssueKey())) {
            MutableIssue viewIssue = this.getIssueManager().getIssueObject(this.getViewIssueKey());
            if (ComponentAccessor.getPermissionManager().hasPermission(10, (Issue)viewIssue, this.getLoggedInUser())) {
                return this.getRedirect("/browse/" + this.getViewIssueKey() + "#summary");
            }
        }
        return super.doPostCreationTasks();
    }

    @Override
    protected void recordHistoryIssueType() {
        this.userIssueTypeManager.setLastUsedSubtaskIssueTypeId(this.getLoggedInUser(), new IssueTypeId(this.getIssuetype()));
    }

    private void createSubTaskLink() throws GenericEntityException, CreateException {
        MutableIssue parentIssue = this.getIssueManager().getIssueObject(this.getParentIssueId());
        this.subTaskManager.createSubTaskIssueLink((Issue)parentIssue, (Issue)this.getIssueObject(), this.getLoggedInUser());
    }

    public String getParentIssueKey() {
        try {
            GenericValue parentIssue = this.getParentIssue();
            if (parentIssue != null) {
                return parentIssue.getString("key");
            }
        }
        catch (GenericEntityException e) {
            this.log.error((Object)"Error occurred while retrieving parent issue.", (Throwable)e);
            this.log.error((Object)"Error occurred while retrieving parent issue. Please see log for more detail.");
        }
        return null;
    }

    public String getParentIssuePath() {
        return "/browse/" + this.getParentIssueKey();
    }

    private GenericValue getParentIssue() throws GenericEntityException {
        return this.getIssueManager().getIssue(this.getParentIssueId());
    }

    public Long getParentIssueId() {
        return this.parentIssueId;
    }

    public void setParentIssueId(Long parentIssueId) {
        this.parentIssueId = parentIssueId;
    }

    public boolean isRequiresLogin() {
        return this.requiresLogin;
    }
}

