/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue.util;

import com.atlassian.jira.issue.AttachmentValidator;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.util.DefaultIssueChangeHolder;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.issue.util.AttachmentHelper;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import webwork.action.ActionContext;

public class DefaultAttachmentHelper
implements AttachmentHelper {
    private final PageBuilderService pageBuilderService;
    private final AttachmentValidator attachmentValidator;
    private final FieldLayoutManager fieldLayoutManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final FieldManager fieldManager;
    private final FieldScreenRendererFactory fieldScreenRendererFactory;

    public DefaultAttachmentHelper(PageBuilderService pageBuilderService, AttachmentValidator attachmentValidator, FieldLayoutManager fieldLayoutManager, JiraAuthenticationContext jiraAuthenticationContext, FieldManager fieldManager, FieldScreenRendererFactory fieldScreenRendererFactory) {
        this.pageBuilderService = pageBuilderService;
        this.attachmentValidator = attachmentValidator;
        this.fieldLayoutManager = fieldLayoutManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.fieldManager = fieldManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
    }

    @Override
    public void requireResources() {
        this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.plugins.jira-dnd-attachment-plugin:drag-and-drop-attachment-javascript-init");
    }

    @Override
    public void populateFieldValuesHolder(String formToken, @Nonnull Map<String, Object> fieldValuesHolder) {
        Objects.nonNull(fieldValuesHolder);
        fieldValuesHolder.put("formToken", formToken);
        OrderableField attachmentField = this.getAttachmentsField();
        attachmentField.populateFromParams(fieldValuesHolder, ActionContext.getParameters());
    }

    @Override
    public void validate(@Nonnull OperationContext operationContext, @Nonnull ErrorCollection errorCollectionToAddTo, @Nonnull I18nHelper i18n, String formToken, @Nonnull Issue issue, @Nonnull Map<String, Object> fieldValuesHolder) {
        Objects.nonNull(operationContext);
        Objects.nonNull(errorCollectionToAddTo);
        Objects.nonNull(i18n);
        Objects.nonNull(issue);
        Objects.nonNull(fieldValuesHolder);
        this.requireResources();
        OrderableField attachmentField = this.getAttachmentsField();
        attachmentField.validateParams(operationContext, errorCollectionToAddTo, i18n, issue, this.getFieldScreenRendererLayoutItemForField(attachmentField, issue));
        if (!((Collection)Optional.ofNullable((Collection)fieldValuesHolder.get(attachmentField.getId())).orElse(Collections.emptyList())).isEmpty()) {
            this.attachmentValidator.canCreateAttachments(this.jiraAuthenticationContext.getLoggedInUser(), issue, errorCollectionToAddTo);
        }
    }

    @Override
    public void processAttachments(@Nonnull MutableIssue mutableIssue, @Nonnull Map<String, Object> fieldValuesHolder) {
        Assertions.notNull((Object)mutableIssue);
        Assertions.notNull(fieldValuesHolder);
        this.requireResources();
        OrderableField attachmentField = this.getAttachmentsField();
        FieldLayoutItem attachmentFieldLayoutItem = this.fieldLayoutManager.getFieldLayout((Issue)mutableIssue).getFieldLayoutItem(attachmentField);
        attachmentField.updateIssue(attachmentFieldLayoutItem, mutableIssue, fieldValuesHolder);
        DefaultIssueChangeHolder changeHolder = new DefaultIssueChangeHolder();
        ModifiedValue modifiedValue = (ModifiedValue)mutableIssue.getModifiedFields().get("attachment");
        if (Objects.nonNull(modifiedValue)) {
            attachmentField.updateValue(attachmentFieldLayoutItem, (Issue)mutableIssue, modifiedValue, (IssueChangeHolder)changeHolder);
            if (!changeHolder.getChangeItems().isEmpty()) {
                ChangeLogUtils.createChangeGroup(this.jiraAuthenticationContext.getLoggedInUser(), mutableIssue.getGenericValue(), mutableIssue.getGenericValue(), (Collection<ChangeItemBean>)changeHolder.getChangeItems(), false);
            }
        }
    }

    private Field getField(String id) {
        return this.fieldManager.getField(id);
    }

    private OrderableField getAttachmentsField() {
        return (OrderableField)this.getField("attachment");
    }

    private FieldScreenRenderLayoutItem getFieldScreenRendererLayoutItemForField(OrderableField field, Issue issue) {
        return this.getFieldScreenRendererWithAllFields(issue).getFieldScreenRenderLayoutItem(field);
    }

    private FieldScreenRenderer getFieldScreenRendererWithAllFields(Issue issue) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(issue, (IssueOperation)IssueOperations.VIEW_ISSUE_OPERATION);
    }
}

