/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.jql;

import com.atlassian.jira.issue.search.jql.LastJqlFieldsService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;

public class JqlRecentFieldsDataProvider
implements WebResourceDataProvider {
    public static final Collection<String> DEFAULT_RECENT_FIELDS = ImmutableList.of((Object)"affectedVersion", (Object)"assignee", (Object)"component", (Object)"description", (Object)"issue", (Object)"labels", (Object)"parent", (Object)"priority", (Object)"project", (Object)"reporter", (Object)"resolution", (Object)"status", (Object[])new String[]{"summary", "type", "watcher"});
    private final Supplier<Delegate> delegateSupplier = Suppliers.memoize(() -> {
        JiraAuthenticationContext authContext = (JiraAuthenticationContext)locator.getComponent(JiraAuthenticationContext.class);
        LastJqlFieldsService lastJqlFieldsService = (LastJqlFieldsService)locator.getComponent(LastJqlFieldsService.class);
        return new Delegate(authContext, lastJqlFieldsService);
    });

    @Inject
    public JqlRecentFieldsDataProvider(ComponentLocator locator) {
    }

    public Jsonable get() {
        return writer -> {
            try {
                this.createResponseObject().write(writer);
            }
            catch (JSONException e) {
                throw new Jsonable.JsonMappingException((Throwable)e);
            }
        };
    }

    private JSONObject createResponseObject() throws JSONException {
        JSONObject response = new JSONObject();
        response.put("key", (Object)"jqlValues");
        response.put("value", (Object)new JSONArray(this.getJqlRecentFieldsJson((Delegate)this.delegateSupplier.get())));
        return response;
    }

    private String getJqlRecentFieldsJson(Delegate delegate) throws JSONException {
        String res = delegate.getJqlRecentFieldsJson();
        if (res.equals("[]")) {
            ApplicationUser applicationUser = delegate.authContext.getLoggedInUser();
            if (applicationUser != null) {
                CompletableFuture.runAsync(() -> this.storeDefaultFields(delegate, applicationUser));
            }
            return new JSONArray(DEFAULT_RECENT_FIELDS).toString();
        }
        return res;
    }

    private void storeDefaultFields(Delegate delegate, ApplicationUser applicationUser) {
        try {
            delegate.lastJqlFieldsService.addSomeFields(applicationUser, DEFAULT_RECENT_FIELDS);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Delegate {
        private final JiraAuthenticationContext authContext;
        private final LastJqlFieldsService lastJqlFieldsService;

        public Delegate(JiraAuthenticationContext authContext, LastJqlFieldsService lastJqlFieldsService) {
            this.authContext = authContext;
            this.lastJqlFieldsService = lastJqlFieldsService;
        }

        private String getJqlRecentFieldsJson() throws JSONException {
            ApplicationUser applicationUser = this.authContext.getLoggedInUser();
            return this.lastJqlFieldsService.getLastFields(applicationUser);
        }
    }
}

