/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.popups;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.worklog.WorklogService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import java.util.Map;

public class ShowTimeTrackingHelp
extends JiraWebActionSupport {
    private ApplicationProperties applicationProperties;

    public ShowTimeTrackingHelp(ApplicationProperties applicationProperties, WorklogService worklogService, IssueService issueService) {
        this.applicationProperties = applicationProperties;
    }

    @SupportedMethods(value={RequestMethod.GET})
    protected String doExecute() throws Exception {
        return super.doExecute();
    }

    public boolean isCommentCopiedToWorkDescription() {
        return this.applicationProperties.getOption("jira.timetracking.copy.comment.to.work.desc.on.transition");
    }

    public String getDefaultTimeUnit() {
        DateUtils.Duration defaultUnit;
        Map map = MapBuilder.newBuilder().add((Object)DateUtils.Duration.MINUTE.name(), (Object)this.getText("core.dateutils.minute")).add((Object)DateUtils.Duration.HOUR.name(), (Object)this.getText("core.dateutils.hour")).add((Object)DateUtils.Duration.DAY.name(), (Object)this.getText("core.dateutils.day")).add((Object)DateUtils.Duration.WEEK.name(), (Object)this.getText("core.dateutils.week")).toMap();
        try {
            defaultUnit = DateUtils.Duration.valueOf((String)this.applicationProperties.getDefaultBackedString("jira.timetracking.default.unit"));
        }
        catch (IllegalArgumentException e) {
            defaultUnit = DateUtils.Duration.MINUTE;
        }
        catch (NullPointerException e) {
            defaultUnit = DateUtils.Duration.MINUTE;
        }
        return (String)map.get(defaultUnit.toString());
    }

    public String getDaysPerWeek() {
        return this.applicationProperties.getDefaultBackedString("jira.timetracking.days.per.week");
    }

    public String getHoursPerDay() {
        return this.applicationProperties.getDefaultBackedString("jira.timetracking.hours.per.day");
    }
}

