/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.project.ViewProject;

public class AddVersion
extends ViewProject {
    private final JiraAuthenticationContext authenticationContext;
    private final VersionService versionService;
    private String name;
    private String releaseDate;
    private String description;
    private Long scheduleAfterVersion;
    private VersionService.CreateVersionValidationResult validationResult;

    public AddVersion(JiraAuthenticationContext authenticationContext, VersionService versionService) {
        this.authenticationContext = authenticationContext;
        this.versionService = versionService;
    }

    @Override
    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        if (this.hasProjectAdminPermission() || this.hasAdminPermission()) {
            return "input";
        }
        return "securitybreach";
    }

    @Override
    protected void doValidation() {
        if (!this.hasProjectAdminPermission()) {
            return;
        }
        this.validationResult = this.versionService.validateCreateVersion(this.getLoggedInUser(), this.getProjectObject(), this.getName(), this.getReleaseDate(), this.getDescription(), this.getScheduleAfterVersion());
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    @Override
    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() throws Exception {
        if (!this.hasProjectAdminPermission()) {
            return "securitybreach";
        }
        this.versionService.createVersion(this.getLoggedInUser(), this.validationResult);
        return this.getRedirect("ManageVersions.jspa?pid=" + this.getProjectObject().getId());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public Long getScheduleAfterVersion() {
        return this.scheduleAfterVersion;
    }

    public void setScheduleAfterVersion(Long scheduleAfterVersion) {
        this.scheduleAfterVersion = scheduleAfterVersion;
    }
}

