/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.web.action.user.ViewProfile;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class GenericEditProfile
extends ViewProfile {
    private String username;
    private String fullname;
    private String email;
    private boolean active;
    private final CrowdService crowdService = (CrowdService)this.getComponentInstanceOfType(CrowdService.class);

    public GenericEditProfile(UserPropertyManager userPropertyManager) {
        super(userPropertyManager);
    }

    public abstract ApplicationUser getEditedUser();

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() throws Exception {
        this.username = this.getEditedUser().getUsername();
        this.fullname = this.getEditedUser().getDisplayName();
        this.email = this.getEditedUser().getEmailAddress();
        this.active = this.getEditedUser().isActive();
        return super.doDefault();
    }

    protected void doValidation() {
        this.log.debug((Object)("fullname = " + this.fullname));
        this.log.debug((Object)("email = " + this.email));
        if (this.username != null && this.username.trim().isEmpty()) {
            this.addError("username", this.getText("signup.error.username.required"));
        }
        if (!TextUtils.stringSet((String)TextUtils.noNull((String)this.fullname).trim())) {
            this.addError("fullname", this.getText("admin.errors.invalid.full.name.specified"));
        }
        if (!TextUtils.verifyEmail((String)TextUtils.noNull((String)this.email))) {
            this.addError("email", this.getText("admin.errors.invalid.email"));
        }
    }

    @Override
    protected String doExecute() throws Exception {
        UserTemplate user = new UserTemplate(this.getEditedUser().getDirectoryUser());
        user.setName(this.username);
        user.setDisplayName(this.fullname);
        user.setEmailAddress(this.email);
        user.setActive(this.active);
        try {
            this.crowdService.updateUser((User)user);
        }
        catch (OperationNotPermittedException e) {
            this.addErrorMessage(this.getText("admin.errors.cannot.edit.user.directory.read.only"));
        }
        catch (OperationFailedException e) {
            this.addErrorMessage(this.getText("admin.editprofile.error.occurred", e.getMessage()));
        }
        return this.getResult();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public void setEmail(String email) {
        this.email = StringUtils.trim((String)email);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

