/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.event.user.OnboardingEvent;
import com.atlassian.jira.plugin.user.PasswordPolicyManager;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.user.PasswordChangeService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ResultException;

public class ResetPassword
extends JiraWebActionSupport {
    private final UserUtil userUtil;
    private final UserManager userManager;
    private final LoginService loginService;
    private final PasswordPolicyManager passwordPolicyManager;
    private final PasswordChangeService passwordChangeService;
    private final EventPublisher eventPublisher;
    private String token;
    private String os_username;
    private String password;
    private String confirm;
    private ApplicationUser userInPlay;
    private boolean userInvalid;
    private boolean tokenTimedOut;
    private boolean tokenInvalid;
    private final List<WebErrorMessage> passwordErrors = new ArrayList<WebErrorMessage>();

    public ResetPassword(UserUtil userUtil, UserManager userManager, LoginService loginService, EventPublisher eventPublisher, PasswordPolicyManager passwordPolicyManager, PasswordChangeService passwordChangeService) {
        this.userUtil = userUtil;
        this.userManager = userManager;
        this.loginService = loginService;
        this.eventPublisher = eventPublisher;
        this.passwordPolicyManager = passwordPolicyManager;
        this.passwordChangeService = passwordChangeService;
    }

    @SupportedMethods(value={RequestMethod.GET})
    public String doDefault() {
        this.validateUserAndToken();
        if (this.isOnboardingUser()) {
            this.eventPublisher.publish((Object)new OnboardingEvent(this.os_username, this.tokenTimedOut));
        }
        if (this.hasAnyErrors()) {
            return "error";
        }
        return "input";
    }

    protected void validate() throws ResultException {
        this.validateUserAndToken();
        if (!(this.userInvalid || this.tokenInvalid || this.tokenTimedOut)) {
            this.validateNewPasswords();
        }
    }

    @SupportedMethods(value={RequestMethod.POST})
    protected String doExecute() {
        if (this.userInvalid || this.tokenInvalid || this.tokenTimedOut || this.invalidInput()) {
            return "error";
        }
        this.passwordChangeService.setPassword((ErrorCollection)this, this.userInPlay, this.password);
        if (this.invalidInput()) {
            return "error";
        }
        return "success";
    }

    private void validateUserAndToken() {
        boolean isValid = true;
        this.userInPlay = this.userManager.getUserByName(this.os_username);
        if (this.userInPlay == null) {
            isValid = false;
            this.userInvalid = true;
        } else {
            UserUtil.PasswordResetTokenValidation validation = this.userUtil.validatePasswordResetToken(this.userInPlay, this.token);
            if (validation.getStatus() == UserUtil.PasswordResetTokenValidation.Status.EXPIRED) {
                isValid = false;
                this.tokenTimedOut = true;
            } else if (validation.getStatus() == UserUtil.PasswordResetTokenValidation.Status.UNEQUAL) {
                isValid = false;
                this.tokenInvalid = true;
            }
        }
        if (!isValid) {
            this.addErrorMessage(this.getText("resetpassword.error.invalid.user.or.token"));
        }
    }

    private void validateNewPasswords() {
        if (StringUtils.isBlank((CharSequence)this.password) || StringUtils.isBlank((CharSequence)this.confirm)) {
            this.addErrorMessage(this.getText("resetpassword.error.password.blank"));
        } else if (!this.nvl(this.password, "").equals(this.confirm)) {
            this.addErrorMessage(this.getText("resetpassword.error.password.mustmatch"));
        } else {
            Collection<WebErrorMessage> messages = this.passwordPolicyManager.checkPolicy(this.userManager.getUserByName(this.os_username), null, this.password);
            if (!messages.isEmpty()) {
                this.addError("password", this.getText("changepassword.new.password.rejected"));
                for (WebErrorMessage message : messages) {
                    this.passwordErrors.add(message);
                }
            }
        }
    }

    private String nvl(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getOs_username() {
        return this.os_username;
    }

    public void setOs_username(String os_username) {
        this.os_username = os_username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public boolean isTokenTimedOut() {
        return this.tokenTimedOut;
    }

    public boolean isTokenInvalid() {
        return this.tokenInvalid;
    }

    public boolean isUserInvalid() {
        return this.userInvalid;
    }

    private long getLoginCount() {
        Long loginCount = this.loginService.getLoginInfo(this.os_username).getLoginCount();
        if (loginCount == null) {
            return 0L;
        }
        return loginCount;
    }

    private boolean isOnboardingUser() {
        return !this.userInvalid && this.getLoginCount() == 0L;
    }
}

