/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.subtask;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.web.component.SimpleColumnLayoutItem;
import java.util.HashMap;
import java.util.Map;

public class ActionsAndOperationsColumnLayoutItem
extends SimpleColumnLayoutItem {
    private static final String CSS_CLASS = "issue_actions";
    private static final String ISSUE_ACTIONS_DROPDOWN_TEMPLATE_PATH = "templates/jira/issue/field/issue-operations.vm";
    private final VelocityTemplatingEngine templatingEngine;
    private final JiraAuthenticationContext authenticationContext;
    private final XsrfTokenGenerator xsrfTokenGenerator;

    public ActionsAndOperationsColumnLayoutItem(VelocityTemplatingEngine templatingEngine, JiraAuthenticationContext authenticationContext, XsrfTokenGenerator xsrfTokenGenerator) {
        this.templatingEngine = templatingEngine;
        this.authenticationContext = authenticationContext;
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    @Override
    protected String getColumnCssClass() {
        return CSS_CLASS;
    }

    @Override
    public String getHtml(Map displayParams, Issue issue) {
        HashMap<String, Object> localParams = new HashMap<String, Object>();
        localParams.put("issue", issue);
        localParams.put("atl_token", this.xsrfTokenGenerator.generateToken());
        localParams.put("displayParams", displayParams);
        localParams.put("i18n", this.authenticationContext.getI18nHelper());
        Map velocityParams = CompositeMap.of(localParams, JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext));
        return this.templatingEngine.render(TemplateSources.file((String)ISSUE_ACTIONS_DROPDOWN_TEMPLATE_PATH)).applying(velocityParams).asHtml();
    }

    @Override
    public String getColumnHeadingKey() {
        return "";
    }
}

