/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.core.filters.encoding.AbstractEncodingFilter;
import com.atlassian.jira.web.filters.InitParamSupport;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;

public class FixedEncodingFilter
extends AbstractEncodingFilter {
    private String encoding;
    private String contentType;

    public FixedEncodingFilter() {
        this(null);
    }

    public FixedEncodingFilter(String encoding) {
        this(encoding, null);
    }

    public FixedEncodingFilter(String encoding, String contentType) {
        this.encoding = encoding;
        this.contentType = contentType;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        this.setEncodingIfNecessary(filterConfig);
        this.validateEncoding();
        this.setContentTypeIfNecessary(filterConfig);
    }

    private void setEncodingIfNecessary(FilterConfig filterConfig) {
        if (!this.encodingSet()) {
            this.encoding = InitParams.ENCODING.get(filterConfig);
        }
    }

    private void setContentTypeIfNecessary(FilterConfig filterConfig) {
        if (!this.contentTypeSet()) {
            this.setContentType(filterConfig);
        }
    }

    private boolean encodingSet() {
        return StringUtils.isNotEmpty((CharSequence)this.encoding);
    }

    private boolean contentTypeSet() {
        return StringUtils.isNotEmpty((CharSequence)this.contentType);
    }

    private void validateEncoding() {
        if (!this.encodingSet()) {
            throw new IllegalStateException("Encoding not provided");
        }
        this.checkEncodingValue();
    }

    private void checkEncodingValue() {
        try {
            Charset.forName(this.encoding);
        }
        catch (UnsupportedCharsetException e) {
            throw new IllegalStateException("Charset unsupported", e);
        }
        catch (IllegalCharsetNameException e) {
            throw new IllegalStateException("No such charset", e);
        }
    }

    private void setContentType(FilterConfig filterConfig) {
        this.contentType = InitParams.CONTENT_TYPE.get(filterConfig);
        if (!this.contentTypeSet()) {
            this.contentType = this.defaultContentType();
        }
    }

    private String defaultContentType() {
        return String.format("text/html; charset=%s", this.encoding);
    }

    protected String getEncoding() {
        return this.encoding;
    }

    protected String getContentType() {
        return this.contentType;
    }

    public static enum InitParams {
        ENCODING(InitParamSupport.optional("jira.encoding.filter.encoding")),
        CONTENT_TYPE(InitParamSupport.optional("jira.encoding.filter.contentType"));

        private final InitParamSupport support;

        private InitParams(InitParamSupport support) {
            this.support = support;
        }

        public String key() {
            return this.support.key();
        }

        String get(FilterConfig config) {
            return this.support.get(config);
        }
    }
}

