/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.accesslog;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class AccessLogIPAddressUtil {
    public static String getRemoteAddr(HttpServletRequest httpServletRequest) {
        String xForwardedFor = httpServletRequest.getHeader("X-Forwarded-For");
        String remoteAddr = httpServletRequest.getRemoteAddr();
        if (StringUtils.isBlank((CharSequence)xForwardedFor) && StringUtils.isBlank((CharSequence)remoteAddr)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)xForwardedFor)) {
            return AccessLogIPAddressUtil.removeSpaces(remoteAddr);
        }
        return AccessLogIPAddressUtil.removeSpaces(xForwardedFor + "," + remoteAddr);
    }

    public static String getShortenedRequestUrl(HttpServletRequest httpServletRequest) {
        String requestURL = StringUtils.trimToEmpty((String)httpServletRequest.getRequestURL().toString());
        requestURL = AccessLogIPAddressUtil.removeHostName(requestURL);
        requestURL = AccessLogIPAddressUtil.removeContextPath(httpServletRequest, requestURL);
        return requestURL;
    }

    private static String removeHostName(String requestURL) {
        int slashIndex;
        int httpIndex = requestURL.indexOf("http://");
        int httpsIndex = requestURL.indexOf("https://");
        if (httpIndex == 0) {
            int slashIndex2 = requestURL.indexOf(47, httpIndex + 7);
            if (slashIndex2 != -1) {
                return requestURL.substring(slashIndex2);
            }
        } else if (httpsIndex == 0 && (slashIndex = requestURL.indexOf(47, httpsIndex + 8)) != -1) {
            return requestURL.substring(slashIndex);
        }
        return requestURL;
    }

    private static String removeContextPath(HttpServletRequest httpServletRequest, String requestURL) {
        String contextPath = StringUtils.trimToEmpty((String)httpServletRequest.getContextPath());
        int index = requestURL.indexOf(contextPath);
        if (index == 0) {
            requestURL = requestURL.substring(index + contextPath.length());
        }
        return requestURL;
    }

    private static String removeSpaces(String s) {
        StringBuilder sb = new StringBuilder();
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

