/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder;

import com.atlassian.jira.servermetrics.RequestCheckpoints;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.jira.web.pagebuilder.FlushEarlyListener;
import com.atlassian.jira.web.pagebuilder.PageBuilderSpi;
import com.atlassian.jira.web.pagebuilder.PageBuildingException;
import com.atlassian.jira.web.pagebuilder.PartialPageRenderer;
import com.atlassian.jira.web.pagebuilder.strategy.PageBuildingStrategy;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultPageBuilder
implements PartialPageRenderer,
PageBuilderSpi {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext servletContext;
    private final ServerMetricsDetailCollector serverMetricsDetailCollector;
    private final FlushEarlyListener flushEarlyListener;
    private boolean finished = false;
    private boolean flushCalled = false;
    private PageBuildingStrategy pageBuildingStrategy = null;

    public DefaultPageBuilder(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, ServerMetricsDetailCollector serverMetricsDetailCollector, FlushEarlyListener flushEarlyListner) {
        this.request = request;
        this.response = response;
        this.servletContext = servletContext;
        this.serverMetricsDetailCollector = serverMetricsDetailCollector;
        this.flushEarlyListener = flushEarlyListner;
    }

    @Override
    public PartialPageRenderer setPageBuildingStrategy(@Nonnull PageBuildingStrategy pageBuildingStrategy) {
        if (this.flushCalled) {
            throw new PageBuildingException("Page building strategy cannot be changed after the flush() method has been called");
        }
        Objects.requireNonNull(pageBuildingStrategy);
        this.pageBuildingStrategy = pageBuildingStrategy;
        pageBuildingStrategy.setUp(this.servletContext, this.request, this.response);
        return this;
    }

    @Override
    public void flush() {
        Objects.requireNonNull(this.pageBuildingStrategy);
        this.flushEarlyListener.onFlushingEarly();
        this.flushCalled = true;
        try {
            this.pageBuildingStrategy.flushEarly();
        }
        catch (IOException ex) {
            throw new PageBuildingException(ex);
        }
    }

    @Override
    public void finish(DecoratablePage page) {
        Objects.requireNonNull(this.pageBuildingStrategy);
        if (this.finished) {
            throw new PageBuildingException("Attempting to call PageBuilder.finish() multiple times");
        }
        this.finished = true;
        this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.beforePageBuilderFinish.name());
        try {
            this.pageBuildingStrategy.finish(page);
        }
        catch (IOException ex) {
            throw new PageBuildingException(ex);
        }
        finally {
            this.serverMetricsDetailCollector.checkpointReached(RequestCheckpoints.pageBuilderFinish.name());
        }
    }
}

