/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.pagebuilder.strategy.flushappheaderearly;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.a11y.A11yPersonalSettingsManager;
import com.atlassian.jira.web.pagebuilder.DecoratablePage;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class BodyClassesWriter {
    private static final Predicate<String> IS_CORRECT_CSS_CLASS = Pattern.compile("^-?[_a-zA-Z]+[_a-zA-Z0-9-]*$").asPredicate();
    private final PrintWriter responseWriter;
    private final SoyTemplateRenderer soyRenderer;

    public BodyClassesWriter(PrintWriter responseWriter, SoyTemplateRenderer soyRenderer) {
        this.responseWriter = responseWriter;
        this.soyRenderer = soyRenderer;
    }

    public void write(DecoratablePage page) {
        List<String> a11yClasses = ((A11yPersonalSettingsManager)ComponentAccessor.getComponent(A11yPersonalSettingsManager.class)).getA11yCssClasses();
        List<String> parsedBodyClassesList = this.parsedClassesAsList(page.getBodyTagProperty("class"));
        List<String> allClasses = Stream.concat(a11yClasses.stream(), parsedBodyClassesList.stream()).filter(IS_CORRECT_CSS_CLASS).collect(Collectors.toList());
        if (!allClasses.isEmpty()) {
            this.responseWriter.println(this.soyRenderer.render("jira.webresources:soy-templates", "JIRA.Templates.FlushAppHeaderEarly.bodyClassesProvider", Collections.singletonMap("bodyClasses", this.classesAsArgumentsList(allClasses))));
        }
    }

    private String classesAsArgumentsList(List<String> cssClasses) {
        if (cssClasses.isEmpty()) {
            return null;
        }
        return "\"" + String.join((CharSequence)"\", \"", cssClasses) + "\"";
    }

    private List<String> parsedClassesAsList(String parsedBodyClasses) {
        if (StringUtils.isBlank((CharSequence)parsedBodyClasses)) {
            return ImmutableList.of();
        }
        return Arrays.asList(parsedBodyClasses.split("\\s+"));
    }
}

