/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.filters.johnson.ServiceUnavailableResponder;
import com.atlassian.jira.web.servlet.AvatarToStream;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvatarServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(AbstractAvatarServlet.class);
    private static final String PARAM_SIZE = "size";
    private static final String PARAM_OWNER_ID = "ownerId";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String ownerId = this.getOwnerId(request);
            Long avatarId = this.getAvatarId(request);
            Avatar.Size size = Avatar.Size.fromString((String)request.getParameter(PARAM_SIZE));
            this.defaultDoGet(request, response, ownerId, avatarId, size);
        }
        catch (NumberFormatException e) {
            response.sendError(404);
        }
    }

    private Long getAvatarId(HttpServletRequest request) throws NumberFormatException {
        return NumberUtils.createLong((String)request.getParameter("avatarId"));
    }

    protected String getOwnerId(HttpServletRequest request) {
        String ownerId = StringUtils.trim((String)request.getParameter(this.getOwnerIdParamName()));
        if (StringUtils.isBlank((CharSequence)ownerId)) {
            ownerId = request.getParameter(PARAM_OWNER_ID);
        }
        return ownerId;
    }

    protected void defaultDoGet(HttpServletRequest request, HttpServletResponse response, String ownerId, Long avatarId, Avatar.Size size) throws IOException, ServletException {
        boolean bytesWritten = false;
        try {
            PreprocessedInput preprocessedInput = this.preprocessInput(ownerId, avatarId, size, response);
            Long realAvatarId = preprocessedInput.avatarId;
            if (realAvatarId == null) {
                return;
            }
            Optional<AvatarManager> avatarManager = this.getAvatarManager();
            if (!avatarManager.isPresent()) {
                ServiceUnavailableResponder.respondWithEmpty503(response);
                return;
            }
            Avatar avatar = avatarManager.get().getById(realAvatarId);
            if (avatar == null) {
                response.sendError(404, "Avatar not found");
            } else if (!this.avatarOkForOwner(ownerId, avatar)) {
                log.warn("Attempted access to avatar " + avatar.getId() + " for owner " + ownerId + " when it doesn't belong to that owner.");
                response.sendError(404);
            } else {
                this.getAvatarToStream().sendAvatar(new AvatarToStream.AvatarData(avatar, size, preprocessedInput.getCachePolicy()), request, response);
                bytesWritten = true;
            }
        }
        catch (IOException | RuntimeException e) {
            AbstractAvatarServlet.handleOutputStreamingException(response, bytesWritten, e);
        }
    }

    protected boolean avatarOkForOwner(String ownerId, Avatar avatar) {
        String owner = avatar.getOwner();
        return owner == null || ownerId != null && IdentifierUtils.equalsInLowerCase((String)ownerId, (String)owner);
    }

    protected static void handleOutputStreamingException(HttpServletResponse response, boolean bytesWritten, Exception e) throws IOException, ServletException {
        if (WebExceptionChecker.canBeSafelyIgnored(e)) {
            return;
        }
        if (bytesWritten || response.isCommitted()) {
            throw new ServletException("Unable to write a coherent response for avatar request", (Throwable)e);
        }
        HttpResponseHeaders.cachePrivatelyForSeconds(response, 86400L);
        response.sendError(404);
    }

    @Nonnull
    protected abstract PreprocessedInput preprocessInput(String var1, Long var2, Avatar.Size var3, HttpServletResponse var4) throws IOException;

    protected abstract String getOwnerIdParamName();

    protected final Optional<AvatarManager> getAvatarManager() {
        return ComponentAccessor.getComponentSafely(AvatarManager.class);
    }

    protected final Optional<FeatureManager> getFeatureManager() {
        return ComponentAccessor.getComponentSafely(FeatureManager.class);
    }

    protected boolean isFeatureEnabled(@Nonnull FeatureFlag featureFlag, boolean whenFeatureManagerNotPresent) {
        return this.getFeatureManager().map(fm -> fm.isEnabled(featureFlag)).orElse(whenFeatureManagerNotPresent);
    }

    protected final AvatarToStream getAvatarToStream() {
        return (AvatarToStream)ComponentAccessor.getComponent(AvatarToStream.class);
    }

    protected static class PreprocessedInput {
        public static final PreprocessedInput SKIP_PROCESSING = new PreprocessedInput(null, null);
        final Long avatarId;
        final AvatarToStream.CachePolicies cachePolicy;

        PreprocessedInput(@Nullable Long avatarId, @Nullable AvatarToStream.CachePolicies cachePolicy) {
            this.avatarId = avatarId;
            this.cachePolicy = cachePolicy;
        }

        public PreprocessedInput(Long avatarId) {
            this(avatarId, null);
        }

        @Nullable
        public Long getAvatarId() {
            return this.avatarId;
        }

        @Nonnull
        public AvatarToStream.CachePolicies getCachePolicy() {
            return this.cachePolicy != null ? this.cachePolicy : AvatarToStream.CachePolicies.YEARS_1;
        }
    }
}

