/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.icon.IconType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.filters.johnson.ServiceUnavailableResponder;
import com.atlassian.jira.web.servlet.AbstractAvatarServlet;
import com.atlassian.jira.web.servlet.AvatarToStream;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewProjectAvatarServlet
extends AbstractAvatarServlet {
    private static final Logger log = LoggerFactory.getLogger(ViewProjectAvatarServlet.class);

    @Override
    protected AbstractAvatarServlet.PreprocessedInput preprocessInput(String projectId, Long avatarId, Avatar.Size size, HttpServletResponse response) throws IOException {
        IconType iconType = IconType.PROJECT_ICON_TYPE;
        Optional<AvatarManager> avatarManagerOptional = this.getAvatarManager();
        if (!avatarManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return AbstractAvatarServlet.PreprocessedInput.SKIP_PROCESSING;
        }
        AvatarManager avatarManager = avatarManagerOptional.get();
        if (StringUtils.isBlank((CharSequence)projectId)) {
            return new AbstractAvatarServlet.PreprocessedInput(avatarManager.getDefaultAvatarId(iconType));
        }
        Optional<ProjectManager> projectManagerOptional = this.getProjectManager();
        if (!projectManagerOptional.isPresent()) {
            ServiceUnavailableResponder.respondWithEmpty503(response);
            return AbstractAvatarServlet.PreprocessedInput.SKIP_PROCESSING;
        }
        Project project = projectManagerOptional.get().getProjectObj(Long.valueOf(Long.parseLong(projectId)));
        if (project == null) {
            response.sendError(404, "Unknown project");
            return AbstractAvatarServlet.PreprocessedInput.SKIP_PROCESSING;
        }
        if (!avatarManager.userCanView(this.getAuthenticationContext().getLoggedInUser(), project.getAvatar())) {
            response.sendError(403, "Unknown project");
            return AbstractAvatarServlet.PreprocessedInput.SKIP_PROCESSING;
        }
        if (avatarId == null) {
            avatarId = project.getAvatar().getId();
        }
        if (this.isFeatureEnabled(JiraFeatureFlagRegistrar.RETURN_DEFAULT_AVATARS_FOR_BROKEN_AVATARS, false) && avatarId != null && !avatarManager.hasImage(avatarManager.getById(avatarId), size)) {
            Long defaultAvatarId = avatarManager.getDefaultAvatarId(iconType);
            log.debug("Unable to obtain avatar data for project {}/{}. Using default project avatar {}.", new Object[]{projectId, avatarId, defaultAvatarId});
            return new AbstractAvatarServlet.PreprocessedInput(defaultAvatarId, AvatarToStream.CachePolicies.DAYS_1);
        }
        return new AbstractAvatarServlet.PreprocessedInput(avatarId);
    }

    @Override
    protected String getOwnerIdParamName() {
        return "pid";
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    Optional<ProjectManager> getProjectManager() {
        return ComponentAccessor.getComponentSafely(ProjectManager.class);
    }
}

