/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.sitemesh;

import com.atlassian.jira.admin.ProjectAdminSidebarFeature;
import com.atlassian.jira.component.ComponentAccessor;
import com.google.common.collect.ImmutableList;
import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.DecoratorMapper;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.mapper.AbstractDecoratorMapper;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ProjectAdminDecoratorMapper
extends AbstractDecoratorMapper {
    private static final List<String> ADMIN_DECORATOR_IDENTIFICATIONS = ImmutableList.of((Object)"admin", (Object)"atl.admin");
    private static final String DECORATOR_PARAM = "meta.decorator";
    private static final String ACTIVE_ADMIN_SECTION = "meta.admin.active.section";
    private static final String ACTIVE_ADMIN_SECTION_VALUE = "atl.jira.proj.config";
    private static final String META_PROJECT_KEY = "meta.projectKey";
    private static final String LOAD_SIDEBAR_KEY = "shouldLoadSidebar";

    public void init(Config config, Properties properties, DecoratorMapper parent) throws InstantiationException {
        super.init(config, properties, parent);
    }

    public Decorator getDecorator(HttpServletRequest request, Page page) {
        request.setAttribute(LOAD_SIDEBAR_KEY, (Object)"false");
        if (page != null) {
            request.setAttribute("projectKey", (Object)page.getProperty(META_PROJECT_KEY));
            if (this.shouldDisplaySidebar() && ADMIN_DECORATOR_IDENTIFICATIONS.contains(page.getProperty(DECORATOR_PARAM)) && ACTIVE_ADMIN_SECTION_VALUE.equals(page.getProperty(ACTIVE_ADMIN_SECTION))) {
                request.setAttribute(LOAD_SIDEBAR_KEY, (Object)"true");
            }
        }
        return super.getDecorator(request, page);
    }

    private boolean shouldDisplaySidebar() {
        return ComponentAccessor.getComponentSafely(ProjectAdminSidebarFeature.class).map(ProjectAdminSidebarFeature::shouldDisplay).orElse(false);
    }
}

