/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.AbstractWorkflowScheme;
import com.atlassian.jira.workflow.AssignableWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowScheme;
import com.atlassian.jira.workflow.DraftWorkflowSchemeBuilder;
import com.atlassian.jira.workflow.DraftWorkflowSchemeStore;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

class DraftWorkflowSchemeImpl
extends AbstractWorkflowScheme
implements DraftWorkflowScheme {
    private final ApplicationUser lastModifiedUser;
    private final Date lastModifiedDate;
    private final AssignableWorkflowScheme parent;

    DraftWorkflowSchemeImpl(Long id, Map<String, String> workflowMap, ApplicationUser lastModifiedUser, Date lastModifiedDate, AssignableWorkflowScheme parent) {
        super(id, workflowMap);
        this.lastModifiedUser = lastModifiedUser;
        this.lastModifiedDate = (Date)Assertions.notNull((String)"lastModifiedDate", (Object)lastModifiedDate);
        this.parent = parent;
    }

    DraftWorkflowSchemeImpl(DraftWorkflowSchemeStore.DraftState state, ApplicationUser lastModifiedUser, AssignableWorkflowScheme parent) {
        super(state.getId(), state.getMappings());
        this.lastModifiedUser = lastModifiedUser;
        this.lastModifiedDate = state.getLastModifiedDate();
        this.parent = parent;
    }

    public ApplicationUser getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    @Nonnull
    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public AssignableWorkflowScheme getParentScheme() {
        return this.parent;
    }

    public DraftWorkflowScheme.Builder builder() {
        return new DraftWorkflowSchemeBuilder(this);
    }

    public String getName() {
        return this.parent == null ? null : this.parent.getName();
    }

    public String getDescription() {
        return this.parent == null ? null : this.parent.getDescription();
    }

    public boolean isDraft() {
        return true;
    }

    public boolean isDefault() {
        return false;
    }
}

