/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.edit;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.edit.WorkflowIssueCountValidator;
import com.atlassian.jira.workflow.edit.events.PublishStatusDeleteFailedIssuesInStatus;
import com.atlassian.jira.workflow.edit.events.StatusDeleteFailedInitialStatus;
import com.atlassian.jira.workflow.edit.events.StatusDeleteFailedIssuesInStatus;
import com.atlassian.jira.workflow.edit.events.StatusDeleteFailedPermissions;
import com.atlassian.jira.workflow.edit.events.StatusDeleteFailedStatusNotFound;
import java.util.Objects;
import javax.validation.constraints.NotNull;

public class WorkflowStatusesValidator {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final EventPublisher eventPublisher;
    private final WorkflowIssueCountValidator workflowIssueCountValidator;
    private final ValidationFailedEvents validationFailedEvents;

    public WorkflowStatusesValidator(JiraAuthenticationContext jiraAuthenticationContext, EventPublisher eventPublisher, WorkflowIssueCountValidator workflowIssueCountValidator) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.eventPublisher = eventPublisher;
        this.workflowIssueCountValidator = workflowIssueCountValidator;
        this.validationFailedEvents = new ValidationFailedEvents();
    }

    public ServiceResult validateStatusDelete(ApplicationUser user, @NotNull JiraWorkflow mutableWorkflow, String statusId) {
        ServiceOutcome<JiraWorkflow> permissionValidation = this.validatePermissions(user, mutableWorkflow);
        if (!permissionValidation.isValid()) {
            this.validationFailedEvents.permissions(mutableWorkflow);
            return ServiceOutcomeImpl.from(permissionValidation.getErrorCollection());
        }
        if (!this.workflowContainsStatus(mutableWorkflow, statusId)) {
            this.validationFailedEvents.missingStatus(mutableWorkflow);
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("workflow.edit.status.not.found", statusId));
        }
        boolean isInitialStatus = this.isInitialStatusInWorkflow(mutableWorkflow, statusId);
        if (isInitialStatus) {
            this.validationFailedEvents.initialStatus(mutableWorkflow);
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("workflow.edit.cannot.delete.initial.status"));
        }
        if (!mutableWorkflow.isActive()) {
            return ServiceOutcomeImpl.ok(null);
        }
        ServiceResult noIssuesValidation = this.workflowIssueCountValidator.validateNoIssuesInStatus(mutableWorkflow.getName(), statusId);
        if (!noIssuesValidation.isValid()) {
            this.validationFailedEvents.issuesInStatus(mutableWorkflow);
            return ServiceOutcomeImpl.from(noIssuesValidation.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private boolean workflowContainsStatus(JiraWorkflow effectiveWorkflow, String statusId) {
        return effectiveWorkflow.getDescriptor().getSteps().stream().anyMatch(sd -> statusId.equals(sd.getMetaAttributes().get("jira.status.id")));
    }

    private boolean isInitialStatusInWorkflow(JiraWorkflow effectiveWorkflow, String statusId) {
        return effectiveWorkflow.getDescriptor().getInitialActions().stream().map(ad -> ad.getUnconditionalResult().getStep()).map(stepId -> effectiveWorkflow.getDescriptor().getStep(stepId.intValue())).anyMatch(stepDescriptor -> Objects.equals(statusId, stepDescriptor.getMetaAttributes().get("jira.status.id")));
    }

    private ServiceOutcome<JiraWorkflow> validatePermissions(ApplicationUser user, JiraWorkflow workflow) {
        if (workflow.isDefault()) {
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("workflow.edit.rest.resource.workflow.not_editable"));
        }
        WorkflowService workflowService = (WorkflowService)ComponentAccessor.getComponent(WorkflowService.class);
        if (!workflowService.isWorkflowEditable(user, workflow)) {
            return ServiceOutcomeImpl.error(this.getI18nBean().getText("workflow.edit.forbidden"));
        }
        return ServiceOutcomeImpl.ok(workflow);
    }

    public ServiceResult validateStatusDeleteWhenOverwriteWorkflow(ApplicationUser user, @NotNull JiraWorkflow liveWorkflow, String statusId) {
        ServiceOutcome<JiraWorkflow> permissionValidation = this.validatePermissions(user, liveWorkflow);
        if (!permissionValidation.isValid()) {
            this.validationFailedEvents.permissions(liveWorkflow);
            return ServiceOutcomeImpl.from(permissionValidation.getErrorCollection());
        }
        ServiceResult noIssuesValidation = this.workflowIssueCountValidator.validateNoIssuesInStatus(liveWorkflow.getName(), statusId);
        if (!noIssuesValidation.isValid()) {
            this.validationFailedEvents.publishIssuesInStatus(liveWorkflow);
            return ServiceOutcomeImpl.from(noIssuesValidation.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok(null);
    }

    private I18nHelper getI18nBean() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }

    private class ValidationFailedEvents {
        private ValidationFailedEvents() {
        }

        void permissions(JiraWorkflow workflow) {
            WorkflowStatusesValidator.this.eventPublisher.publish((Object)new StatusDeleteFailedPermissions(workflow));
        }

        public void missingStatus(JiraWorkflow workflow) {
            WorkflowStatusesValidator.this.eventPublisher.publish((Object)new StatusDeleteFailedStatusNotFound(workflow));
        }

        public void initialStatus(JiraWorkflow workflow) {
            WorkflowStatusesValidator.this.eventPublisher.publish((Object)new StatusDeleteFailedInitialStatus(workflow));
        }

        public void issuesInStatus(JiraWorkflow workflow) {
            WorkflowStatusesValidator.this.eventPublisher.publish((Object)new StatusDeleteFailedIssuesInStatus(workflow));
        }

        public void publishIssuesInStatus(JiraWorkflow jiraWorkflow) {
            WorkflowStatusesValidator.this.eventPublisher.publish((Object)new PublishStatusDeleteFailedIssuesInStatus(jiraWorkflow));
        }
    }
}

