/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.auth;

import com.atlassian.mail.auth.JiraMailOAuth2Credentials;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@Immutable
class DefaultJiraMailOAuth2Credentials
implements JiraMailOAuth2Credentials {
    private final String userName;
    private final String accessToken;
    private final String refreshToken;
    private final String tokenId;
    private final Properties properties;

    DefaultJiraMailOAuth2Credentials(String userName, String accessToken, String refreshToken, String tokenId, Properties properties) {
        this.userName = userName;
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
        this.tokenId = tokenId;
        this.properties = properties;
    }

    @Override
    public String getTokenId() {
        return this.tokenId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public Optional<Properties> getProperties() {
        return Optional.ofNullable(this.properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultJiraMailOAuth2Credentials that = (DefaultJiraMailOAuth2Credentials)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.accessToken, that.accessToken) && Objects.equals(this.refreshToken, that.refreshToken) && Objects.equals(this.tokenId, that.tokenId) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.accessToken, this.refreshToken, this.tokenId, this.properties);
    }
}

