/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers.jira;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.db.config.password.Cipher;
import com.atlassian.db.config.password.DefaultCipherProvider;
import com.atlassian.db.config.password.ciphers.base64.Base64Cipher;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.BuildUtilsInfoImpl;
import com.atlassian.jira.util.lang.Pair;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public class EncryptionManager {
    public static final String BASE_64_CIPHER = "Base64Cipher";
    private static final Map<String, String> ciphersMap = Collections.singletonMap("Base64Cipher", Base64Cipher.class.getCanonicalName());
    private final BuildUtilsInfo buildUtilsInfo;

    public EncryptionManager() {
        this.buildUtilsInfo = new BuildUtilsInfoImpl();
    }

    @VisibleForTesting
    public EncryptionManager(BuildUtilsInfo buildUtilsInfo) {
        this.buildUtilsInfo = buildUtilsInfo;
    }

    private Optional<Cipher> getCipherInstance(String cipherType) {
        return new DefaultCipherProvider().getInstance(cipherType);
    }

    Pair<String, String> encryptPassword(String plainPassword, String cipherType) {
        if (!this.isEncryptionAllowed() || plainPassword == null || cipherType == null) {
            return Pair.nicePairOf((Object)plainPassword, null);
        }
        Cipher cipher = this.getCipherInstance(ciphersMap.get(cipherType)).orElseThrow(() -> new IllegalArgumentException("There is no cipher for given type : " + cipherType + "."));
        return Pair.of((Object)cipher.encrypt(plainPassword), (Object)cipherType);
    }

    String decryptPassword(String encryptedPassword, String cipherType) {
        if (encryptedPassword != null && cipherType != null) {
            Cipher cipher = this.getCipherInstance(ciphersMap.get(cipherType)).orElseThrow(() -> new IllegalArgumentException("There is no cipher for given type : " + cipherType + "."));
            return cipher.decrypt(encryptedPassword);
        }
        return encryptedPassword;
    }

    boolean isEncryptionAllowed() {
        return this.buildUtilsInfo.getDatabaseBuildNumber() >= 812001;
    }
}

