/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.config.ConfigFile;
import com.atlassian.jira.util.Function;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public final class ConfigFileWalker {
    private File root;
    private ArrayList<IOFileFilter> excludes = new ArrayList();
    private FileFilter filter = null;
    private ConfigVisitor visitor = null;
    private Function<File, ConfigFile> configFileFactory = null;

    public ConfigFileWalker(File root, ConfigVisitor visitor) {
        this(root, visitor, DefaultConfigFileFactory.INSTANCE);
    }

    public ConfigFileWalker(File root, ConfigVisitor visitor, Function<File, ConfigFile> configFileFactory) {
        this.setRoot(root);
        this.setVisitor(visitor);
        this.setConfigFileFactory(configFileFactory);
    }

    public File getRoot() {
        return this.root;
    }

    public ConfigFileWalker setRoot(File root) {
        this.root = ConfigFileWalker.normalizeFile(root);
        return this;
    }

    public ConfigFileWalker setExcludes(Collection<IOFileFilter> excludes) {
        this.filter = null;
        this.excludes = excludes == null ? new ArrayList() : new ArrayList<IOFileFilter>(excludes);
        return this;
    }

    public ConfigFileWalker addFileNameExclude(String fileName) {
        this.filter = null;
        this.excludes.add((IOFileFilter)new NameFileFilter(fileName));
        return this;
    }

    public ConfigVisitor getVisitor() {
        return this.visitor;
    }

    public ConfigFileWalker setVisitor(ConfigVisitor visitor) {
        this.visitor = visitor;
        return this;
    }

    public Function<File, ConfigFile> getConfigFileFactory() {
        return this.configFileFactory;
    }

    public ConfigFileWalker setConfigFileFactory(Function<File, ConfigFile> configFileFactory) {
        this.configFileFactory = configFileFactory;
        return this;
    }

    public void walk() {
        if (this.root == null) {
            throw new IllegalStateException("The root has not been set.");
        }
        if (!this.root.exists()) {
            throw new IllegalStateException(String.format("Root '%s' does not exist", this.root.getAbsolutePath()));
        }
        if (this.visitor == null) {
            throw new IllegalStateException("The visitor has not been set.");
        }
        this.processFile(this.root);
    }

    private FileFilter getFilter() {
        if (this.filter == null) {
            OrFileFilter tmpFilter = new OrFileFilter(Arrays.asList(new WildcardFileFilter("*.xml", IOCase.INSENSITIVE), new WildcardFileFilter("*.zip", IOCase.INSENSITIVE), FileFilterUtils.directoryFileFilter()));
            if (!this.excludes.isEmpty()) {
                OrFileFilter orFilter = new OrFileFilter(this.excludes);
                tmpFilter = FileFilterUtils.andFileFilter((IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)orFilter), (IOFileFilter)tmpFilter);
            }
            this.filter = FileFilterUtils.makeSVNAware((IOFileFilter)tmpFilter);
        }
        return this.filter;
    }

    private void processFile(File file) {
        if (file.isFile()) {
            this.processConfig(ConfigFileWalker.normalizeFile(file));
        } else {
            for (File sub : file.listFiles(this.getFilter())) {
                this.processFile(sub);
            }
        }
    }

    private void processConfig(File file) {
        try {
            this.visitor.visitConfig(this.configFileFactory.apply(file));
        }
        catch (ConfigFile.ConfigFileException e) {
            this.visitor.visitConfigError(file, e);
        }
    }

    private static File normalizeFile(File file) {
        if (file == null) {
            return file;
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            return file.getAbsoluteFile();
        }
    }

    private static class DefaultConfigFileFactory
    implements Function<File, ConfigFile> {
        private static final DefaultConfigFileFactory INSTANCE = new DefaultConfigFileFactory();

        private DefaultConfigFileFactory() {
        }

        @Override
        public ConfigFile apply(File input) {
            return ConfigFile.create(input);
        }
    }

    public static interface ConfigVisitor {
        public void visitConfig(ConfigFile var1);

        public void visitConfigError(File var1, ConfigFile.ConfigFileException var2);
    }
}

