/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config;

import com.atlassian.jira.functest.framework.JUnit5Adapter;
import com.atlassian.jira.functest.framework.SuiteListenerWrapper;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FuncSuiteAssertions {
    private static final Logger logger = LoggerFactory.getLogger(FuncSuiteAssertions.class);

    private FuncSuiteAssertions() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static void assertSuitesEqual(Test suite1, Test suite2) {
        LinkedHashSet caseClasses1 = Sets.newLinkedHashSet(FuncSuiteAssertions.collectCaseClasses(suite1));
        LinkedHashSet caseClasses2 = Sets.newLinkedHashSet(FuncSuiteAssertions.collectCaseClasses(suite2));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)caseClasses1.containsAll(caseClasses2)).overridingErrorMessage("New tests not found in old suite:\n" + Sets.difference((Set)caseClasses2, (Set)caseClasses1), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)caseClasses2.containsAll(caseClasses1)).overridingErrorMessage("Old tests not found in new suite:\n" + Sets.difference((Set)caseClasses1, (Set)caseClasses2), new Object[0])).isTrue();
    }

    public static void assertOldTestsInNewSuite(Test oldSuite, Test newSuite, Class<?> ... exceptions) {
        Sets.SetView caseClasses1 = Sets.difference((Set)Sets.newLinkedHashSet(FuncSuiteAssertions.collectCaseClasses(oldSuite)), new HashSet(Arrays.asList(exceptions)));
        LinkedHashSet caseClasses2 = Sets.newLinkedHashSet(FuncSuiteAssertions.collectCaseClasses(newSuite));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)caseClasses2.containsAll((Collection<?>)caseClasses1)).overridingErrorMessage("Old tests not found in new suite:\n" + Sets.difference((Set)caseClasses1, (Set)caseClasses2), new Object[0])).isTrue();
    }

    public static void assertHasTests(Test suite, Class<? extends Test> ... testClasses) {
        List<Class<?>> actualTestClasses = FuncSuiteAssertions.collectCaseClasses(suite);
        for (Class<? extends Test> testClass : testClasses) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualTestClasses.contains(testClass)).overridingErrorMessage("Classes in suite " + actualTestClasses + " do not contain expected class " + testClass, new Object[0])).isTrue();
        }
    }

    public static void assertDoesNotHaveTests(Test suite, Class<? extends Test> ... testClasses) {
        List<Class<?>> actualTestClasses = FuncSuiteAssertions.collectCaseClasses(suite);
        for (Class<? extends Test> testClass : testClasses) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualTestClasses.contains(testClass)).overridingErrorMessage("Classes in suite " + actualTestClasses + " contain unexpected class " + testClass, new Object[0])).isFalse();
        }
    }

    public static void assertHasTestNames(Test suite, String ... testNames) {
        List<String> actualTestNames = FuncSuiteAssertions.collectCaseNames(FuncSuiteAssertions.extractSuite(suite));
        for (String testName : testNames) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualTestNames.contains(testName)).overridingErrorMessage("Test names in suite " + actualTestNames + " do not contain expected name " + testName, new Object[0])).isTrue();
        }
    }

    public static void assertDoesNotHaveTestNames(Test suite, String ... testNames) {
        List<String> actualTestNames = FuncSuiteAssertions.collectCaseNames(FuncSuiteAssertions.extractSuite(suite));
        for (String testName : testNames) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)actualTestNames.contains(testName)).overridingErrorMessage("Test names in suite " + actualTestNames + " contain unexpected name " + testName, new Object[0])).isFalse();
        }
    }

    public static void assertNumberOfTestCasesEquals(int expected, Test suite) {
        Assertions.assertThat((int)FuncSuiteAssertions.collectCases(FuncSuiteAssertions.extractSuite(suite)).size()).isEqualTo(expected);
    }

    public static List<Test> collectCases(TestSuite suite) {
        ArrayList<Test> answer = new ArrayList<Test>();
        for (Test test : CollectionUtil.toList(suite.tests())) {
            if (test instanceof TestSuite) {
                answer.addAll(FuncSuiteAssertions.collectCases((TestSuite)test));
                continue;
            }
            answer.add(test);
        }
        return answer;
    }

    public static List<Class<?>> collectCaseClasses(Test suite) {
        return FuncSuiteAssertions.collectCaseClasses(FuncSuiteAssertions.extractSuite(suite));
    }

    public static List<Class<?>> collectCaseClasses(TestSuite suite) {
        return FuncSuiteAssertions.filterDuplicates(CollectionUtil.transform(FuncSuiteAssertions.collectCases(suite), input -> {
            if (input instanceof JUnit5Adapter) {
                return ((JUnit5Adapter)input).getDescription().getTestClass();
            }
            if (input instanceof JUnit4TestAdapter) {
                return ((JUnit4TestAdapter)input).getTestClass();
            }
            return input.getClass();
        }));
    }

    private static TestSuite extractSuite(Test test) {
        if (test instanceof TestSuite) {
            return (TestSuite)test;
        }
        if (test instanceof SuiteListenerWrapper) {
            return FuncSuiteAssertions.extractSuite(((SuiteListenerWrapper)test).delegate());
        }
        throw new IllegalArgumentException("Unable to extract TestSuite from " + test.getClass().getName());
    }

    public static List<String> collectCaseNames(TestSuite suite) {
        return FuncSuiteAssertions.filterDuplicates(CollectionUtil.transform(FuncSuiteAssertions.collectCases(suite), input -> {
            if (input instanceof TestCase) {
                return ((TestCase)input).getName();
            }
            return "";
        }));
    }

    public static void logSuites(Test oldOne, Test newOne) {
        List<Class<?>> oldList = FuncSuiteAssertions.collectCaseClasses(oldOne);
        List<Class<?>> newList = FuncSuiteAssertions.collectCaseClasses(newOne);
        int size = Math.max(oldList.size(), newList.size());
        logger.info("[logSuites] Comparing case classes lists");
        for (int i = 0; i < size; ++i) {
            logger.info(String.format("%-60s%s", FuncSuiteAssertions.safeGetName(oldList, i), FuncSuiteAssertions.safeGetName(newList, i)));
        }
    }

    private static String safeGetName(List<Class<?>> list, int index) {
        if (list.size() <= index) {
            return "<empty>";
        }
        return list.get(index).getSimpleName();
    }

    private static <T> List<T> filterDuplicates(List<T> testClasses) {
        return new ArrayList<T>(new LinkedHashSet<T>(testClasses));
    }
}

