/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.crowd;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckResultBuilder;
import com.atlassian.jira.functest.config.ConfigurationCheck;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.config.crowd.ConfigCrowdApplication;
import org.apache.commons.lang3.StringUtils;

public class CrowdApplicationCheck
implements ConfigurationCheck {
    public static final String CHECK_APPLICATION_TYPE = "crowdapplicationtype";

    @Override
    public ConfigurationCheck.Result checkConfiguration(JiraConfig config, CheckOptions options) {
        CheckResultBuilder builder = new CheckResultBuilder();
        if (options.checkEnabled(CHECK_APPLICATION_TYPE)) {
            for (ConfigCrowdApplication application : config.getCrowdApplications()) {
                if (!StringUtils.isBlank((CharSequence)application.getApplicationType())) continue;
                String name = application.getName() == null ? "<unknown>" : application.getName();
                builder.error("Crowd application '" + name + "' exists without type.", CHECK_APPLICATION_TYPE);
            }
        }
        return builder.buildResult();
    }

    @Override
    public void fixConfiguration(JiraConfig config, CheckOptions options) {
        for (ConfigCrowdApplication crowdApplication : config.getCrowdApplications()) {
            if (!options.checkEnabled(CHECK_APPLICATION_TYPE) || !StringUtils.isBlank((CharSequence)crowdApplication.getApplicationType())) continue;
            crowdApplication.setApplicationType("CROWD");
        }
    }
}

