/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.config.service;

import com.atlassian.jira.functest.config.ConfigCrudHelper;
import com.atlassian.jira.functest.config.ConfigException;
import com.atlassian.jira.functest.config.ConfigSequence;
import com.atlassian.jira.functest.config.ConfigXmlUtils;
import com.atlassian.jira.functest.config.ps.ConfigPropertySet;
import com.atlassian.jira.functest.config.ps.ConfigPropertySetManager;
import com.atlassian.jira.functest.config.service.ConfigService;
import com.atlassian.jira.functest.config.service.ConfigServiceManager;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class DefaultConfigServiceManager
implements ConfigServiceManager {
    private final ConfigCrudHelper<ConfigService> helper;

    public DefaultConfigServiceManager(Document document, ConfigPropertySetManager propertySetManager, ConfigSequence configSeqence) {
        this.helper = new Helper(document, configSeqence, propertySetManager);
    }

    @Override
    public List<ConfigService> loadServices() {
        return this.helper.load();
    }

    @Override
    public boolean saveServices(List<ConfigService> newList) {
        return this.helper.save(newList);
    }

    private static class Helper
    extends ConfigCrudHelper<ConfigService> {
        private static final String ELEMENT_SERVICE_CONFIG = "ServiceConfig";
        private static final String ATTRIBUTE_ID = "id";
        private static final String ATTRIBUTE_TIME = "time";
        private static final String ATTRIBUTE_CLAZZ = "clazz";
        private static final String ATTRIBUTE_NAME = "name";
        private final ConfigPropertySetManager psm;

        private Helper(Document document, ConfigSequence configSequence, ConfigPropertySetManager psm) {
            super(document, configSequence, ELEMENT_SERVICE_CONFIG);
            this.psm = psm;
        }

        @Override
        protected ConfigService elementToObject(Element element) {
            Long id = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_ID);
            if (id == null) {
                throw new ConfigException("Trying to read service without an ID.");
            }
            Long time = ConfigXmlUtils.getLongValue(element, ATTRIBUTE_TIME);
            String clazz = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_CLAZZ);
            String name = ConfigXmlUtils.getTextValue(element, ATTRIBUTE_NAME);
            return new ConfigService(id, time, clazz, name, this.psm.loadPropertySet(ELEMENT_SERVICE_CONFIG, id));
        }

        @Override
        protected void updateObject(Element element, ConfigService updateObject, ConfigService oldObject) {
            this.setAttributes(element, updateObject);
            ConfigPropertySet propertySet = updateObject.getPropertySet();
            if (propertySet != null) {
                this.psm.savePropertySet(propertySet.copyForEntity(ELEMENT_SERVICE_CONFIG, updateObject.getId()));
            } else if (oldObject.getPropertySet() != null) {
                this.psm.deletePropertySet(oldObject.getPropertySet());
            }
        }

        @Override
        protected void newObject(Element element, ConfigService newObject, Long newId) {
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_ID, newId);
            this.setAttributes(element, newObject);
            ConfigPropertySet propertySet = newObject.getPropertySet();
            if (propertySet != null) {
                this.psm.savePropertySet(propertySet.copyForEntity(ELEMENT_SERVICE_CONFIG, newId));
            }
        }

        private void setAttributes(Element element, ConfigService newObject) {
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_TIME, newObject.getTimeout());
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_NAME, (Object)newObject.getName());
            ConfigXmlUtils.setAttribute(element, ATTRIBUTE_CLAZZ, (Object)newObject.getClazz());
        }

        @Override
        protected void deleteObject(Element element, ConfigService deleteObject) {
            this.psm.deletePropertySet(deleteObject.getPropertySet());
        }
    }
}

