/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.util.ProgressPageControl;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebTable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;
import org.xml.sax.SAXException;

public class BulkOperations {
    private final WebTester tester;
    private final FuncTestLogger logger;
    private final Navigation navigation;
    private final Administration administration;
    private final Assertions assertions;
    public static final String SAME_FOR_ALL = "sameAsBulkEditBean";

    @Inject
    public BulkOperations(WebTester tester, FuncTestLogger logger, Navigation navigation, Administration administration, Assertions assertions) {
        this.tester = tester;
        this.logger = logger;
        this.navigation = navigation;
        this.administration = administration;
        this.assertions = assertions;
    }

    public void bulkChangeIncludeAllPages() {
        this.tester.gotoPage("/views/bulkedit/BulkEdit1!default.jspa?reset=true&tempMax=10000");
    }

    public void bulkChangeIncludeCurrentPage() {
        this.tester.gotoPage("/views/bulkedit/BulkEdit1!default.jspa?reset=true");
    }

    public void isStepChooseIssues() {
        this.tester.assertTextPresent("Bulk Operation: Choose Issues");
        this.logger.log((Object)"Step 1 of 4");
    }

    public void isStepChooseOperation() {
        this.tester.assertTextPresent("Bulk Operation: Choose Operation");
        this.logger.log((Object)"Step 2 of 4");
    }

    public void isStepOperationDetails() {
        this.tester.assertTextPresent("Bulk Operation: Operation Details");
        this.logger.log((Object)"Step 3 of 4");
    }

    public void isStepConfirmation() {
        this.tester.assertTextPresent("Confirmation");
        this.logger.log((Object)"Step 4 of 4");
    }

    public void bulkChangeSelectIssue(String key) {
        this.isStepChooseIssues();
        this.bulkOperationCheckIssues(Collections.singletonList(key));
        this.tester.submit("Next");
    }

    public void bulkChangeSelectIssues(Collection keys) {
        this.isStepChooseIssues();
        this.bulkOperationCheckIssues(keys);
        this.tester.submit("Next");
    }

    private void bulkOperationCheckIssues(Collection keys) {
        try {
            boolean checkBoxColumn = false;
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("issuetable");
            int keyColumn = -1;
            for (int i = 0; i < table.getColumnCount(); ++i) {
                String headerCell = table.getCellAsText(0, i);
                if (!headerCell.trim().equals("Key")) continue;
                keyColumn = i;
            }
            if (keyColumn < 0) {
                Fail.fail((String)"Could not find column for Key");
            }
            int checkBoxesChecked = 0;
            for (int i = 0; i < table.getRowCount(); ++i) {
                String key = table.getCellAsText(i, keyColumn);
                if (!keys.contains(key.trim())) continue;
                TableCell checkBoxCell = table.getTableCell(i, 0);
                String[] elementNames = checkBoxCell.getElementNames();
                boolean foundCheckbox = false;
                for (String elementName : elementNames) {
                    if (!elementName.startsWith("bulkedit_")) continue;
                    this.tester.checkCheckbox(elementName);
                    if (++checkBoxesChecked >= keys.size()) {
                        return;
                    }
                    foundCheckbox = true;
                    break;
                }
                if (foundCheckbox) continue;
                Fail.fail((String)("Could not find the check box for issue with key '" + key + "'."));
            }
        }
        catch (SAXException e) {
            e.printStackTrace();
            Fail.fail((String)"Error occurred selecting issues.");
        }
    }

    public void waitAndReloadBulkOperationProgressPage() {
        this.tester.assertTextPresent("Bulk Operation Progress");
        ProgressPageControl.waitAndReload(this.tester, "bulkoperationprogressform", "Refresh", "Acknowledge");
        this.logger.log((Object)"waitAndReloadBulkOperationProgressPage");
    }

    public void bulkChangeChooseOperationEdit() {
        this.isStepChooseOperation();
        this.tester.setFormElement("operation", "bulk.edit.operation.name");
        this.tester.assertRadioOptionSelected("operation", "bulk.edit.operation.name");
        this.logger.log((Object)"Operation Selected: Edit Issues");
        this.tester.submit("Next");
    }

    public void setBulkEditFieldTo(String field, String listValue) {
        this.logger.log((Object)("Set " + field + " To: \"" + listValue + "\""));
        this.tester.checkCheckbox("actions", field);
        this.tester.selectOption(field, listValue);
        this.tester.assertOptionEquals(field, listValue);
    }

    public void bulkEditOperationDetailsSetAs(Map<String, String> fields) {
        this.isStepOperationDetails();
        this.tester.assertFormElementEquals("actions", null);
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            String value = entry.getValue();
            if ("fixVersions".equals(fieldName)) {
                this.setBulkEditFieldTo("fixVersions", value);
            }
            if ("versions".equals(fieldName)) {
                this.setBulkEditFieldTo("versions", value);
            }
            if ("components".equals(fieldName)) {
                this.setBulkEditFieldTo("components", value);
            }
            if ("assignee".equals(fieldName)) {
                this.setBulkEditFieldTo("assignee", value);
            }
            if (!"priority".equals(fieldName)) continue;
            this.setBulkEditFieldTo("priority", value);
        }
        this.tester.submit("Next");
    }

    public void bulkEditConfirmEdit(Map<String, String> fields) {
        this.isStepConfirmation();
        for (Map.Entry<String, String> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            String value = entry.getValue();
            if ("fixVersions".equals(fieldName)) {
                this.tester.assertTextPresent("Fix Version/s");
                this.tester.assertTextPresent(value);
            }
            if ("versions".equals(fieldName)) {
                this.tester.assertTextPresent("Affects Version/s");
                this.tester.assertTextPresent(value);
            }
            if ("components".equals(fieldName)) {
                this.tester.assertTextPresent("Component/s");
                this.tester.assertTextPresent(value);
            }
            if ("assignee".equals(fieldName)) {
                this.tester.assertTextPresent("Assignee");
                this.tester.assertTextPresent(value);
            }
            if (!"priority".equals(fieldName)) continue;
            this.tester.assertTextPresent("Priority");
            this.tester.assertTextPresent(value);
        }
    }

    public void bulkChangeConfirm() {
        this.isStepConfirmation();
        this.tester.submit("Confirm");
        this.logger.log((Object)"Confirmed");
    }

    public void bulkChangeCancel() {
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "#cancel"), "Cancel");
        this.tester.clickLink("cancel");
        this.tester.assertTextPresent("Issue Navigator");
        this.logger.log((Object)"Canceled");
    }

    public void bulkChangeChooseIssuesAll() {
        String[] paramNames;
        this.isStepChooseIssues();
        this.tester.getDialog().setWorkingForm("bulkedit");
        for (String paramName : paramNames = this.tester.getDialog().getForm().getParameterNames()) {
            if (!paramName.startsWith("bulkedit_")) continue;
            this.tester.checkCheckbox(paramName);
        }
        this.tester.submit("Next");
    }

    public void chooseOperationExecuteWorfklowTransition() {
        this.isStepChooseOperation();
        this.tester.setFormElement("operation", "bulk.workflowtransition.operation.name");
        this.tester.assertRadioOptionSelected("operation", "bulk.workflowtransition.operation.name");
        this.logger.log((Object)"Operation Selected: Transition Issues");
        this.tester.submit("Next");
    }

    public void chooseOperationBulkMove() {
        this.isStepChooseOperation();
        this.tester.setFormElement("operation", "bulk.move.operation.name");
        this.tester.assertRadioOptionSelected("operation", "bulk.move.operation.name");
        this.logger.log((Object)"Operation Selected: Move Issues");
        this.tester.submit("Next");
    }

    public void deleteAllIssuesInAllPages() {
        String[] parameterNames;
        boolean mailServerExists = this.isMailServerExists();
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        this.navigation.issueNavigator().displayAllIssues();
        this.logger.log((Object)"Deleting all issues");
        this.tester.assertElementPresent("issuetable");
        this.tester.gotoPage("/secure/views/bulkedit/BulkEdit1!default.jspa?reset=true&tempMax=10000");
        this.tester.assertTextPresent("Bulk Operation: Choose Issues");
        this.tester.setWorkingForm("bulkedit");
        WebForm form = this.tester.getDialog().getForm();
        for (String name : parameterNames = form.getParameterNames()) {
            if (!name.startsWith("bulkedit_")) continue;
            this.tester.checkCheckbox(name);
        }
        this.tester.submit("Next");
        this.tester.assertTextPresent("Bulk Operation: Choose Operation");
        this.tester.setFormElement("operation", "bulk.delete.operation.name");
        this.tester.assertRadioOptionSelected("operation", "bulk.delete.operation.name");
        this.tester.submit("Next");
        if (mailServerExists) {
            this.tester.submit("Next");
        }
        this.tester.assertTextPresent("Bulk Operation: Confirmation");
        this.tester.submit("Confirm");
        this.waitAndReloadBulkOperationProgressPage();
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    private boolean isMailServerExists() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.OUTGOING_MAIL);
        String testExisitingMailServerId = "sendTestEmail";
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//*[@id='sendTestEmail']");
        return xPathLocator.getNodes().length > 0;
    }
}

