/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;
import org.xml.sax.SAXException;

public class EditIssueFieldVisibility {
    private static final String HIDE_FIELD_OPERATION_NAME = "Hide";
    private static final String SHOW_FIELD_OPERATION_NAME = "Show";
    private static final String OPTIONAL_FIELD_OPERATION_NAME = "Optional";
    private static final int FIELD_TABLE_FIELD_NAME_COLUMN_INDEX = 0;
    private static final int FIELD_TABLE_OPERATIONS_COLUMN_INDEX = 2;
    private static final String PAGE_ENTERPRISE_FIELD_CONFIGURATIONS = "/secure/admin/ViewFieldLayouts.jspa";
    private final Navigation navigation;
    private final WebTester tester;
    private final FuncTestLogger logger;

    @Inject
    public EditIssueFieldVisibility(Navigation navigation, WebTester tester, FuncTestLogger logger) {
        this.navigation = navigation;
        this.tester = tester;
        this.logger = logger;
    }

    public void setHiddenFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, HIDE_FIELD_OPERATION_NAME);
    }

    private void gotoFieldLayoutOnEnterprise(String fieldLayoutName) {
        this.navigation.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.tester.assertTextPresent("View Field Configurations");
        this.tester.clickLinkWithText(fieldLayoutName);
    }

    public void setShownFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, SHOW_FIELD_OPERATION_NAME);
    }

    public void setRequiredFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.setRequiredField(fieldName);
    }

    public void setOptionalFieldsOnEnterprise(String fieldLayoutName, String fieldName) {
        this.gotoFieldLayoutOnEnterprise(fieldLayoutName);
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, OPTIONAL_FIELD_OPERATION_NAME);
    }

    public void setRequiredField(String fieldName) {
        this.assertViewIssueFields();
        try {
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID("field_table");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (!field.contains(fieldName)) continue;
                TableCell linkCell = fieldTable.getTableCell(i, 2);
                WebLink requiredLink = linkCell.getLinkWith("Required");
                if (requiredLink == null) {
                    Fail.fail((String)("Cannot find 'required' link for field '" + fieldName + "'."));
                    continue;
                }
                requiredLink.click();
                return;
            }
            Fail.fail((String)("Cannot find field with id '" + fieldName + "'."));
        }
        catch (SAXException e) {
            Fail.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
        }
        catch (IOException e) {
            Fail.fail((String)("Cannot click 'required' link for field id '" + fieldName + "'."));
        }
    }

    public void setRequiredFields() {
        this.resetFields();
        this.logger.log((Object)"Set fields to be required");
        this.gotoViewIssueFields();
        this.setRequiredField("Affects Version/s");
        this.setRequiredField("Fix Version/s");
        this.setRequiredField("Component/s");
    }

    public void setHiddenFields(String fieldName) {
        this.logger.log((Object)("Hide field " + fieldName));
        this.gotoViewIssueFields();
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, HIDE_FIELD_OPERATION_NAME);
    }

    public void setShownFields(String fieldName) {
        this.logger.log((Object)("Show field " + fieldName));
        this.gotoViewIssueFields();
        this.assertViewIssueFields();
        this.doFieldOperation(fieldName, SHOW_FIELD_OPERATION_NAME);
    }

    public void doFieldOperation(String fieldName, String linkName) {
        this.assertViewIssueFields();
        try {
            WebTable fieldTable = this.tester.getDialog().getResponse().getTableWithID("field_table");
            for (int i = 1; i < fieldTable.getRowCount(); ++i) {
                String field = fieldTable.getCellAsText(i, 0);
                if (!field.contains(fieldName)) continue;
                TableCell linkCell = fieldTable.getTableCell(i, 2);
                WebLink link = linkCell.getLinkWith(linkName);
                if (link == null) {
                    this.logger.log((Object)("Link with name '" + linkName + "' does not exist."));
                    return;
                }
                link.click();
                return;
            }
            Fail.fail((String)("Cannot find field with id '" + fieldName + "'."));
        }
        catch (SAXException e) {
            Fail.fail((String)"Cannot find table with id 'field_table'.");
            e.printStackTrace();
        }
        catch (IOException e) {
            Fail.fail((String)("Cannot click '" + linkName + "' link for field id '" + fieldName + "'."));
        }
    }

    public void resetFields() {
        this.logger.log((Object)"Restore default field settings");
        this.gotoViewIssueFields();
        if (this.tester.getDialog().isLinkPresentWithText("Restore Defaults")) {
            this.tester.clickLinkWithText("Restore Defaults");
        }
    }

    public void setDueDateToRequried() {
        this.resetFields();
        this.logger.log((Object)"Set 'Due Date' Field to required");
        this.gotoViewIssueFields();
        this.setRequiredField("Due Date");
    }

    public void setSecurityLevelToRequried() {
        this.resetFields();
        this.logger.log((Object)"Set 'Security Level' Field to required");
        this.gotoViewIssueFields();
        this.setRequiredField("Security Level");
    }

    public void assertViewIssueFields() {
        this.tester.assertTextPresent("View Field Configuration");
    }

    private void gotoViewIssueFields() {
        this.navigation.gotoPage(PAGE_ENTERPRISE_FIELD_CONFIGURATIONS);
        this.tester.assertTextPresent("View Field Configurations");
        this.tester.clickLinkWithText("Configure");
        this.tester.assertTextPresent("View Field Configuration");
    }
}

