/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Form;
import com.google.common.collect.ImmutableList;
import com.meterware.httpunit.Button;
import com.meterware.httpunit.WebForm;
import javax.inject.Inject;
import net.sourceforge.jwebunit.UnableToSetFormException;
import net.sourceforge.jwebunit.WebTester;
import net.sourceforge.jwebunit.util.ExceptionUtility;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.xml.sax.SAXException;

public class FormImpl
implements Form {
    private WebTester webTester;

    @Inject
    public FormImpl(WebTester webTester) {
        this.webTester = webTester;
    }

    @Override
    public void selectOption(String selectName, String option) {
        this.webTester.assertFormElementPresent(selectName);
        this.webTester.selectOption(selectName, option);
    }

    @Override
    public void selectOptionsByDisplayName(String selectName, String option, String ... moreOptions) {
        this.selectOptionsByDisplayName(selectName, this.join(option, moreOptions));
    }

    @Override
    public void selectOptionsByDisplayName(String selectName, String[] options) {
        this.webTester.assertFormElementPresent(selectName);
        this.checkFormStateWithParameter(selectName);
        if (options.length > 0) {
            this.webTester.getDialog().getForm().setParameter(selectName, this.getValuesForOptions(selectName, options));
        } else {
            this.webTester.getDialog().getForm().removeParameter(selectName);
        }
    }

    @Override
    public void selectOptionsByValue(String selectName, String option, String ... moreOptions) {
        this.selectOptionsByValue(selectName, this.join(option, moreOptions));
    }

    @Override
    public void selectOptionsByValue(String selectName, String[] options) {
        this.webTester.assertFormElementPresent(selectName);
        this.checkFormStateWithParameter(selectName);
        if (options.length > 0) {
            this.webTester.getDialog().getForm().setParameter(selectName, options);
        } else {
            this.webTester.getDialog().getForm().removeParameter(selectName);
        }
    }

    private String[] getValuesForOptions(String selectName, String[] options) {
        String[] values = new String[options.length];
        for (int i = 0; i < options.length; ++i) {
            String option = options[i];
            values[i] = this.webTester.getDialog().getValueForOption(selectName, option);
        }
        return values;
    }

    private void checkFormStateWithParameter(String paramName) {
        if (this.webTester.getDialog().getForm() == null) {
            try {
                this.webTester.getDialog().setWorkingForm(this.getFormWithParameter(paramName).getID());
            }
            catch (UnableToSetFormException e) {
                throw new UnableToSetFormException("Unable to set form based on parameter [" + paramName + "].");
            }
        }
    }

    private WebForm getFormWithParameter(String paramName) {
        for (int i = 0; i < this.getForms().length; ++i) {
            String[] names;
            WebForm webForm = this.getForms()[i];
            for (String name : names = webForm.getParameterNames()) {
                if (!name.equals(paramName)) continue;
                return webForm;
            }
        }
        return null;
    }

    @Override
    public WebForm[] getForms() {
        try {
            return this.webTester.getDialog().getResponse().getForms();
        }
        catch (SAXException ex) {
            throw new RuntimeException("Unable to get forms from the WebResponse.", ex);
        }
    }

    @Override
    public WebForm switchTo(String formId) {
        this.webTester.setWorkingForm(formId);
        return this.webTester.getDialog().getForm();
    }

    private String[] join(String option, String[] moreOptions) {
        ImmutableList list = ImmutableList.builder().add((Object)option).add((Object[])moreOptions).build();
        return (String[])list.toArray((Object[])new String[list.size()]);
    }

    @Override
    public void clickButtonWithValue(String value) {
        Button[] buttons;
        this.assertButtonPresentWithValue(value);
        Button buttonToClick = null;
        for (Button button : buttons = this.webTester.getDialog().getForm().getButtons()) {
            if (!value.equals(button.getValue())) continue;
            buttonToClick = button;
            break;
        }
        this.clickButton(buttonToClick);
    }

    @Override
    public void clickAnyButtonWithValue(String value) {
        Button[] buttons;
        this.assertAnyButtonPresentWithValue(value);
        Button buttonToClick = null;
        for (Button button : buttons = this.webTester.getDialog().getForm().getButtons()) {
            if (!value.equals(button.getValue())) continue;
            buttonToClick = button;
            break;
        }
        this.clickButton(buttonToClick);
    }

    private void clickButton(Button buttonToClick) {
        try {
            Assertions.assertThat((Object)buttonToClick).isNotNull();
            if (buttonToClick.getID() != null) {
                this.webTester.clickButton(buttonToClick.getID());
            } else {
                if (buttonToClick.getName() != null) {
                    this.webTester.setFormElement(buttonToClick.getName(), buttonToClick.getValue());
                }
                this.webTester.submit();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(ExceptionUtility.stackTraceToString((Throwable)e));
        }
    }

    private void assertButtonPresentWithValue(String value) {
        Button[] buttons;
        Button buttonToAssert = null;
        for (Button button : buttons = this.webTester.getDialog().getForm().getButtons()) {
            if (!value.equals(button.getValue())) continue;
            if (buttonToAssert != null) {
                Fail.fail((String)("Found multiple buttons with value: " + value + "\n" + this.foundButtons()));
            }
            buttonToAssert = button;
        }
        if (buttonToAssert == null) {
            Fail.fail((String)("Did not find button with value: " + value + "\n" + this.foundButtons()));
        }
    }

    private void assertAnyButtonPresentWithValue(String value) {
        Button[] buttons;
        for (Button button : buttons = this.webTester.getDialog().getForm().getButtons()) {
            if (!value.equals(button.getValue())) continue;
            return;
        }
        Fail.fail((String)("Did not find button with value: " + value));
    }

    private String foundButtons() {
        StringBuilder result = new StringBuilder();
        Button[] buttons = this.webTester.getDialog().getForm().getButtons();
        for (int i = 0; i < buttons.length; ++i) {
            Button button = buttons[i];
            result.append("Button[");
            if (button.getID() != null) {
                result.append("id:").append(button.getID()).append(" ");
            }
            result.append(button.getName());
            result.append("=");
            result.append(button.getValue());
            result.append("]");
            if (i == buttons.length - 1) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

