/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class FuncTestUrlHelper {
    private final String baseUrl;

    @Inject
    public FuncTestUrlHelper(JIRAEnvironmentData environmentData) {
        this.baseUrl = environmentData.getBaseUrl().toExternalForm();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getBaseUrlPlus(String ... paths) {
        return this.getBaseUrlPlus(Arrays.asList(paths));
    }

    public String getBaseUrlPlus(Iterable<String> paths) {
        Iterable pathsNoLeadingSlashes = Iterables.transform(paths, (Function)new Function<String, String>(){

            public String apply(String path) {
                return path.startsWith("/") ? path.substring(1) : path;
            }
        });
        String path = pathsNoLeadingSlashes != null ? StringUtils.join((Iterable)Lists.newArrayList((Iterable)pathsNoLeadingSlashes), (char)'/') : "";
        return String.format("%s/%s", this.getBaseUrl(), path);
    }

    public URI getBaseUriPlus(Iterable<String> paths) {
        try {
            return new URI(this.getBaseUrlPlus(paths));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public URI getBaseUriPlus(String ... paths) {
        return this.getBaseUriPlus(Arrays.asList(paths));
    }

    public String getRestApiUrl(String ... paths) {
        List<String> list = CollectionBuilder.newBuilder("rest", "api", "2").addAll(paths).asList();
        return this.getBaseUrlPlus(list);
    }

    public URI getRestApiUri(String ... paths) {
        return this.getRestApiUri(Arrays.asList(paths));
    }

    public URI getRestApiUri(Iterable<String> paths) {
        ArrayList all = Lists.newArrayList((Object[])new String[]{"rest", "api", "2"});
        all.addAll(Lists.newArrayList(paths));
        return this.getBaseUriPlus(all);
    }
}

