/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.webtests.table.HtmlTable;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class Instruments {
    private static final String TYPE_HEADING = "Type";
    private static final String NAME_HEADING = "Name";
    private static final String VALUE_HEADING = "Value";
    private static final String INSTRUMENT_TABLE_ID = "instrument_table";
    private static final String VIEW_INSTRUMENTATION_PATH = "/secure/admin/ViewInstrumentation!default.jspa";
    private static final String INSTRUMENT_TYPE_COUNTER = "Counter";
    private final Navigation navigation;
    private final HtmlPage page;

    @Inject
    public Instruments(Navigation navigation, HtmlPage page) {
        this.navigation = navigation;
        this.page = page;
    }

    @Nonnull
    public Counters readAllCounters() throws ParseException {
        this.navigation.gotoPage(VIEW_INSTRUMENTATION_PATH);
        List<HtmlTable.Row> allRows = this.page.getHtmlTable(INSTRUMENT_TABLE_ID).getRows();
        List<HtmlTable.Row> dataRows = allRows.subList(1, allRows.size());
        HashMap counters = Maps.newHashMap();
        for (HtmlTable.Row row : dataRows) {
            long counterValue;
            String instrumentType = row.getCellForHeading(TYPE_HEADING);
            if (!INSTRUMENT_TYPE_COUNTER.equals(instrumentType)) continue;
            String counterName = row.getCellForHeading(NAME_HEADING);
            String counterValueString = row.getCellForHeading(VALUE_HEADING);
            try {
                counterValue = NumberFormat.getIntegerInstance().parse(counterValueString).longValue();
            }
            catch (NumberFormatException badFormat) {
                throw new NumberFormatException("Can't parse counter number: " + counterName){

                    @Override
                    public Throwable getCause() {
                        return badFormat;
                    }
                };
            }
            counters.put(counterName, new Counter(counterName, counterValue));
        }
        return new Counters(counters);
    }

    public static class Counters {
        private final Map<String, Counter> counters;

        public Counters(Map<String, Counter> counters) {
            this.counters = ImmutableMap.copyOf(counters);
        }

        @Nonnull
        public Counter getCounter(String name) {
            if (this.counters.containsKey(name)) {
                return this.counters.get(name);
            }
            return new Counter(name);
        }
    }

    public static class Counter {
        private final String name;
        private final Optional<Long> value;

        public Counter(String name) {
            this.name = name;
            this.value = Optional.absent();
        }

        public Counter(String name, long value) {
            this.name = name;
            this.value = Optional.of((Object)value);
        }

        public String getName() {
            return this.name;
        }

        public Optional<Long> getValue() {
            return this.value;
        }
    }
}

