/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.JUnit5TestCaseFacade;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.runner.Describable;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnit5Adapter
implements Test,
Filterable,
Describable {
    private static final Logger logger = LoggerFactory.getLogger(JUnit5Adapter.class);
    private final TestIdentifier testIdentifier;
    private final Description description;
    private final Launcher launcher;
    private int testsCount;

    public JUnit5Adapter(TestIdentifier testIdentifier, int testsCount, Launcher launcher) {
        this.testIdentifier = testIdentifier;
        this.launcher = launcher;
        this.testsCount = testsCount;
        this.description = this.createDescription(testIdentifier);
    }

    private Description createDescription(TestIdentifier testIdentifier) {
        Supplier<Description> fallbackDescriptionSupplier = () -> Description.createSuiteDescription((String)testIdentifier.getLegacyReportingName(), (Serializable)((Object)testIdentifier.getUniqueId()), (Annotation[])new Annotation[0]);
        return testIdentifier.getSource().map(source -> {
            if (source instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)testIdentifier.getSource().get();
                String displayName = testIdentifier.getDisplayName();
                if (!displayName.contains(methodSource.getMethodName())) {
                    displayName = methodSource.getMethodName() + " -> " + displayName;
                }
                return Description.createTestDescription((String)methodSource.getClassName(), (String)displayName, (Serializable)((Object)testIdentifier.getUniqueId()));
            }
            if (source instanceof ClassSource) {
                ClassSource classSource = (ClassSource)testIdentifier.getSource().get();
                return Description.createSuiteDescription((String)classSource.getClassName(), (Serializable)((Object)testIdentifier.getUniqueId()), (Annotation[])new Annotation[0]);
            }
            return (Description)fallbackDescriptionSupplier.get();
        }).orElseGet(fallbackDescriptionSupplier);
    }

    public int countTestCases() {
        return this.testsCount;
    }

    public void run(final TestResult result) {
        this.launcher.execute(LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectUniqueId((UniqueId)this.testIdentifier.getUniqueIdObject())}).build(), new TestExecutionListener[]{new TestExecutionListener(){

            public void dynamicTestRegistered(TestIdentifier testIdentifier) {
                logger.info("Dynamic test {} registered", (Object)testIdentifier.getUniqueId());
                if (testIdentifier.isTest()) {
                    JUnit5Adapter.this.testsCount++;
                }
            }

            public void executionSkipped(TestIdentifier testIdentifier, String reason) {
                logger.info("Execution of {} skipped because {}", (Object)testIdentifier.getUniqueId(), (Object)reason);
            }

            public void executionStarted(TestIdentifier testIdentifier) {
                if (testIdentifier.isTest()) {
                    logger.info("Started {}", (Object)testIdentifier.getUniqueId());
                    result.startTest(JUnit5Adapter.this.createTest(testIdentifier));
                }
            }

            public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                if (testIdentifier.isTest()) {
                    logger.info("Finished {}", (Object)testIdentifier.getUniqueId());
                    Test test = JUnit5Adapter.this.createTest(testIdentifier);
                    switch (testExecutionResult.getStatus()) {
                        case FAILED: {
                            result.addError(test, (Throwable)testExecutionResult.getThrowable().orElse(new RuntimeException("Unknown error occured:" + testExecutionResult.getStatus())));
                            break;
                        }
                        case ABORTED: {
                            result.addError(test, (Throwable)new TestAbortedException());
                            break;
                        }
                    }
                    result.endTest(test);
                }
            }
        }});
    }

    private Test createTest(TestIdentifier testIdentifier) {
        return this.createTest(this.createDescription(testIdentifier));
    }

    private Test createTest(Description description) {
        if (description.isTest()) {
            return new JUnit5TestCaseFacade(description);
        }
        TestSuite suite = new TestSuite(description.getDisplayName());
        for (Description child : description.getChildren()) {
            suite.addTest(this.createTest(child));
        }
        return suite;
    }

    public Description getDescription() {
        return this.description;
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        if (!filter.shouldRun(this.description)) {
            throw new NoTestsRemainException();
        }
    }
}

