/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.parser.Header;
import com.atlassian.jira.functest.framework.parser.IssueNavigatorParser;
import com.atlassian.jira.functest.framework.parser.IssueNavigatorParserImpl;
import com.atlassian.jira.functest.framework.parser.IssueParser;
import com.atlassian.jira.functest.framework.parser.IssueParserImpl;
import com.atlassian.jira.functest.framework.parser.SystemInfoParser;
import com.atlassian.jira.functest.framework.parser.SystemInfoParserImpl;
import com.atlassian.jira.functest.framework.parser.filter.FilterParser;
import com.atlassian.jira.functest.framework.parser.filter.FilterParserImpl;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class ParserImpl
implements Parser {
    private final IssueParser issue;
    private final FilterParser filter;
    private final SystemInfoParser systemInfoParser;
    private final IssueNavigatorParser issueNavigatorParser;
    private final LocatorFactory locators;

    @Inject
    public ParserImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.filter = new FilterParserImpl(tester, environmentData);
        this.systemInfoParser = new SystemInfoParserImpl(tester, environmentData, 2, new NavigationImpl(tester, environmentData));
        this.issueNavigatorParser = new IssueNavigatorParserImpl(tester, environmentData, 2);
        this.locators = new LocatorFactoryImpl(tester);
        this.issue = new IssueParserImpl(tester, environmentData, new WorkflowUtil(tester, environmentData, this.locators));
    }

    @Override
    public IssueParser issue() {
        return this.issue;
    }

    @Override
    public FilterParser filter() {
        return this.filter;
    }

    @Override
    public SystemInfoParser systemInfo() {
        return this.systemInfoParser;
    }

    @Override
    public IssueNavigatorParser navigatorParser() {
        return this.issueNavigatorParser;
    }

    @Override
    public Header header() {
        return () -> this.locators.id("header-details-user-fullname").getNode().getAttributes().getNamedItem("data-displayname").getTextContent();
    }
}

