/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.JUnit5Adapter;
import com.atlassian.jira.functest.framework.util.testcase.TestCaseKit;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import com.atlassian.jira.webtests.util.TestCaseMethodNameDetector;
import com.atlassian.jira.webtests.util.TestClassUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import junit.framework.JUnit4TestAdapter;
import junit.framework.JUnit4TestCaseFacade;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.junit.Ignore;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;

public class TestSuiteBuilder {
    private final Set<Class<?>> testClasses = new LinkedHashSet();
    private final Launcher launcher = LauncherFactory.create();
    private int maxBatch;
    private int batch;
    private boolean log;

    public TestSuiteBuilder(int batch, int maxBatch) {
        this.batch(batch).maxBatch(maxBatch).log(false);
    }

    public TestSuiteBuilder() {
        this(-1, -1);
    }

    private static void outputTest(TestSuite suite) {
        Enumeration enumeration = suite.tests();
        while (enumeration.hasMoreElements()) {
            Test nextTest = (Test)enumeration.nextElement();
            TestSuiteBuilder.outputTestCase(nextTest);
        }
    }

    private static void outputTestCase(Test nextTest) {
        FuncTestOut.log((Object)TestCaseKit.getFullName(nextTest));
    }

    public TestSuiteBuilder addTests(Collection<Class<?>> tests) {
        this.testClasses.addAll(tests);
        return this;
    }

    public TestSuiteBuilder log(boolean log) {
        this.log = log;
        return this;
    }

    public TestSuiteBuilder batch(int batch) {
        if (batch == 0) {
            throw new IllegalArgumentException("batch == 0");
        }
        this.batch = batch;
        return this;
    }

    public TestSuiteBuilder maxBatch(int maxBatch) {
        if (maxBatch == 0) {
            throw new IllegalArgumentException("maxBatch == 0");
        }
        this.maxBatch = maxBatch;
        return this;
    }

    private boolean isBatchMode() {
        return this.batch >= 0;
    }

    public TestSuite build() {
        return this.isBatchMode() ? this.createTestBatch(this.batch, this.maxBatch) : this.createAllTest();
    }

    private TestSuite createAllTest() {
        TestSuite suite = new TestSuite();
        this.getAllTestsStream().forEach(arg_0 -> ((TestSuite)suite).addTest(arg_0));
        if (this.log) {
            FuncTestOut.log((Object)"** Tests in global **");
            TestSuiteBuilder.outputTest(suite);
            FuncTestOut.log((Object)"** End tests in global **");
        }
        return suite;
    }

    @VisibleForTesting
    Stream<Test> getAllTestsStream() {
        return this.testClasses.stream().flatMap(this::getTestsForClass).filter(val -> val != null);
    }

    private Stream<Test> getTestsForClass(Class<?> clazz) {
        if (TestCase.class.isAssignableFrom(clazz)) {
            return Collections.list(new TestSuite(clazz).tests()).stream().filter(test -> {
                TestCaseMethodNameDetector detector = new TestCaseMethodNameDetector((TestCase)test);
                Method method = detector.resolve();
                return method != null && method.getAnnotation(Ignore.class) == null;
            });
        }
        if (TestClassUtils.isJunit5TestClass(clazz)) {
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(clazz)}).build();
            TestPlan testPlan = this.launcher.discover(request);
            return testPlan.getRoots().stream().flatMap(testIdentifier -> this.getPlanChildren(testPlan, (TestIdentifier)testIdentifier).stream()).map(testIdentifier -> new JUnit5Adapter((TestIdentifier)testIdentifier, this.calcNumberOfTests((TestIdentifier)testIdentifier, testPlan), this.launcher));
        }
        JUnit4TestAdapter jUnit4TestAdapter = new JUnit4TestAdapter(clazz);
        return jUnit4TestAdapter.getTests().stream().map(test -> {
            if (test instanceof TestSuite) {
                return Collections.list(((TestSuite)test).tests());
            }
            return Arrays.asList(test);
        }).flatMap(Collection::stream).map(test -> (JUnit4TestCaseFacade)test).filter(test -> test.getDescription().getMethodName() != null).map(testFacade -> {
            JUnit4TestAdapter newTestAdapter = new JUnit4TestAdapter(clazz, (JUnit4TestCaseFacade)testFacade){
                final /* synthetic */ JUnit4TestCaseFacade val$testFacade;
                {
                    this.val$testFacade = jUnit4TestCaseFacade;
                    super(x0);
                }

                public String toString() {
                    return this.val$testFacade.getDescription().toString();
                }
            };
            try {
                newTestAdapter.filter(Filter.matchMethodDescription((Description)testFacade.getDescription()));
            }
            catch (NoTestsRemainException e) {
                throw new IllegalStateException(String.format("We should always end up with one test. Test class=%s, description=%s", clazz.getName(), testFacade.getDescription().toString()), e);
            }
            return newTestAdapter;
        });
    }

    private List<TestIdentifier> getPlanChildren(TestPlan testPlan, TestIdentifier testIdentifier) {
        ArrayList<TestIdentifier> testIdentifiers = new ArrayList<TestIdentifier>();
        if (testIdentifier.getUniqueId().equals("[engine:junit-vintage]")) {
            return testIdentifiers;
        }
        if (testIdentifier.getSource().isPresent() && testIdentifier.getSource().get() instanceof ClassSource) {
            return Collections.singletonList(testIdentifier);
        }
        if (testIdentifier.isTest()) {
            testIdentifiers.add(testIdentifier);
        }
        if (testIdentifier.isContainer()) {
            testPlan.getChildren(testIdentifier).forEach(child -> testIdentifiers.addAll(this.getPlanChildren(testPlan, (TestIdentifier)child)));
        }
        return testIdentifiers;
    }

    private int calcNumberOfTests(TestIdentifier testIdentifier, TestPlan testPlan) {
        int testsCount = 0;
        if (testIdentifier.isTest()) {
            ++testsCount;
        }
        if (testIdentifier.isContainer()) {
            for (TestIdentifier child : testPlan.getChildren(testIdentifier)) {
                testsCount += this.calcNumberOfTests(child, testPlan);
            }
        }
        return testsCount;
    }

    @VisibleForTesting
    TestSuite createTestBatch(int batchNo, int maxBatches) {
        this.checkBatchState(batchNo, maxBatches);
        TestSuite suite = new TestSuite();
        List tests = this.getAllTestsStream().collect(Collectors.toList());
        int numberOfTests = tests.size();
        if (tests.isEmpty() || batchNo > tests.size()) {
            return suite;
        }
        int currentBatchSize = numberOfTests / maxBatches;
        if (numberOfTests % maxBatches > 0) {
            ++currentBatchSize;
        }
        ((List)Lists.partition(tests, (int)currentBatchSize).get(batchNo - 1)).forEach(arg_0 -> ((TestSuite)suite).addTest(arg_0));
        return suite;
    }

    private void checkBatchState(int batchNo, int maxBatches) {
        if (maxBatches <= 0) {
            throw new IllegalStateException("maxBatches has to be greater than 0");
        }
        if (batchNo > maxBatches) {
            throw new IllegalStateException(String.format("batch(%d) > maxBatch(%d).", batchNo, maxBatches));
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

