/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.ProgressBar;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.backdoor.Backdoor;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.assertj.core.api.Fail;

public class WorkflowSchemes {
    private final WebTester tester;
    private final Assertions assertions;
    private final Backdoor backdoor;
    private final ProgressBar progressBar;
    private final Navigation navigation;

    @Inject
    public WorkflowSchemes(WebTester tester, Assertions assertions, Backdoor backdoor, ProgressBar progressBar, Navigation navigation) {
        this.tester = tester;
        this.assertions = assertions;
        this.backdoor = backdoor;
        this.progressBar = progressBar;
        this.navigation = navigation;
    }

    public void addWorkFlowScheme(String name, String description) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOW_SCHEMES);
        this.tester.clickLink("add_workflowscheme");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("description", description);
        this.tester.submit("Add");
    }

    public void deleteWorkFlowScheme(String workflowscheme_name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.WORKFLOW_SCHEMES);
        String linkId = "del_" + workflowscheme_name;
        if (this.tester.getDialog().isLinkPresent(linkId)) {
            this.tester.clickLink(linkId);
            this.tester.submit("Delete");
        }
    }

    public void waitForSuccessfulWorkflowSchemeMigration(String projectName, String targetWorkflowName) {
        int MAX_ITERATIONS = 100;
        int its = 0;
        while (true) {
            if (++its > 100) {
                Fail.fail((String)"The Workflow Migration took longer than 100 attempts!  Why?");
            }
            if (this.tester.getDialog().getResponseText().contains("type=\"submit\" name=\"Refresh\"")) {
                this.tester.submit("Refresh");
            } else {
                if (this.tester.getDialog().getResponseText().contains("type=\"submit\" name=\"Done\"")) {
                    this.progressBar.validateProgressBarUI("Done");
                    this.tester.submit("Done");
                    this.assertions.getSidebarAssertions().assertProjectName(projectName);
                    WorkflowSchemeData scheme = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectName(projectName);
                    org.assertj.core.api.Assertions.assertThat((String)targetWorkflowName).isEqualTo(scheme.getName());
                    return;
                }
                if (this.tester.getDialog().getResponseText().contains("input type=\"submit\" name=\"Acknowledge\"")) {
                    this.progressBar.validateProgressBarUI("Acknowledge");
                    this.tester.submit("Acknowledge");
                    this.assertions.getSidebarAssertions().assertProjectName(projectName);
                    WorkflowSchemeData scheme = this.backdoor.workflowSchemes().getWorkflowSchemeByProjectName(projectName);
                    org.assertj.core.api.Assertions.assertThat((String)targetWorkflowName).isEqualTo(scheme.getName());
                    return;
                }
                if (this.tester.getDialog().getElement("project-config-header-name") != null) {
                    return;
                }
                Fail.fail((String)("Page encountered during migration that was not expected : PROJECT:" + projectName + " - WORKFLOW SCHEME NAME" + targetWorkflowName));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Fail.fail((String)"Test interupted");
                continue;
            }
            break;
        }
    }
}

