/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.admin.EditNotifications;
import com.atlassian.jira.functest.framework.admin.NotificationType;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class EditNotificationsImpl
implements EditNotifications {
    private final WebTester tester;
    private final LocatorFactory locators;

    @Inject
    public EditNotificationsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.locators = new LocatorFactoryImpl(tester);
    }

    public EditNotificationsImpl(WebTester tester, JIRAEnvironmentData environmentData, int logIndentLevel) {
        this(tester, environmentData);
    }

    @Override
    public int notificationSchemeId() {
        return Integer.parseInt(this.locators.id("notification-scheme-id").getNode().getAttributes().getNamedItem("value").getNodeValue());
    }

    @Override
    public EditNotifications addNotificationsForEvent(int eventId, NotificationType notificationType) {
        this.goAndSelectType(eventId, notificationType);
        this.submitAdd();
        return this;
    }

    @Override
    public EditNotifications addNotificationsForEvent(int eventId, NotificationType notificationType, String paramValue) {
        this.goAndSelectType(eventId, notificationType);
        if (notificationType == NotificationType.GROUP) {
            FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "jiraform", "Add");
            formParameterUtil.addOptionToHtmlSelect(notificationType.uiCode(), new String[]{paramValue});
            formParameterUtil.setFormElement(notificationType.uiCode(), paramValue);
            formParameterUtil.submitForm();
            this.tester.clickLinkWithText("Cancel");
        } else {
            this.tester.setFormElement(notificationType.uiCode(), paramValue);
            this.submitAdd();
        }
        return this;
    }

    @Override
    public EditNotifications deleteEntryWithId(int entryId) {
        this.tester.clickLink("del_" + entryId);
        this.tester.submit("Delete");
        return this;
    }

    private void goAndSelectType(int eventId, NotificationType notificationType) {
        this.tester.clickLink("add_" + eventId);
        this.tester.setWorkingForm("jiraform");
        this.tester.checkRadioOption("type", notificationType.uiCode());
    }

    private void submitAdd() {
        this.tester.submit("Add");
    }
}

