/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.FormImpl;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LocatorFactoryImpl;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurationSchemes;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;

public class FieldConfigurationSchemesImpl
implements FieldConfigurationSchemes,
FieldConfigurationSchemes.FieldConfigurationScheme {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private final Form form;
    private final LocatorFactory locators;
    private Navigation navigation;
    private String fieldConfigurationSchemeId;
    private String fieldConfigurationSchemeName;

    @Inject
    public FieldConfigurationSchemesImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
        this.form = new FormImpl(tester);
        this.locators = new LocatorFactoryImpl(tester);
        this.navigation = null;
    }

    protected Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }

    @Override
    public String addFieldConfigurationScheme(String name, String description) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.tester.clickLink("add-field-configuration-scheme");
        this.tester.setFormElement("fieldLayoutSchemeName", name);
        if (description != null) {
            this.tester.setFormElement("fieldLayoutSchemeDescription", description);
        }
        this.tester.submit("Add");
        return StringUtils.trimToNull((String)this.locators.xpath("//*[@data-scheme-field='name']/@data-id").getText());
    }

    @Override
    public FieldConfigurationSchemes.FieldConfigurationScheme fieldConfigurationScheme(String name) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.fieldConfigurationSchemeId = this.getSchemeIdForName(name);
        this.fieldConfigurationSchemeName = name;
        return this;
    }

    @Override
    public FieldConfigurationSchemes.FieldConfigurationScheme goTo() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.getNavigation().clickLinkWithExactText(this.fieldConfigurationSchemeName);
        return this;
    }

    @Override
    public void addAssociation(String issueTypeId, String fieldConfigurationName) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.getNavigation().clickLinkWithExactText(this.fieldConfigurationSchemeName);
        this.tester.clickLink("add-issue-type-field-configuration-association");
        this.tester.setWorkingForm("add-issue-type-field-configuration-association-form");
        this.form.selectOptionsByValue("issueTypeId", new String[]{issueTypeId});
        this.tester.selectOption("fieldConfigurationId", fieldConfigurationName);
        this.tester.submit("Add");
        this.tester.assertLinkPresent("edit_fieldlayoutschemeentity_" + issueTypeId);
    }

    @Override
    public void editAssociation(String issueTypeId, String newFieldConfigurationName) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.getNavigation().clickLinkWithExactText(this.fieldConfigurationSchemeName);
        String editLink = "edit_fieldlayoutschemeentity";
        if (issueTypeId != null) {
            editLink = editLink + "_" + issueTypeId;
        }
        this.tester.clickLink(editLink);
        this.tester.setWorkingForm("jiraform");
        this.tester.selectOption("fieldConfigurationId", newFieldConfigurationName);
        this.tester.submit("Update");
    }

    @Override
    public void removeAssociation(String issueTypeId) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.ISSUE_FIELDS);
        this.getNavigation().clickLinkWithExactText(this.fieldConfigurationSchemeName);
        this.tester.clickLink("delete_fieldlayoutschemeentity_" + issueTypeId);
        this.tester.assertLinkNotPresent("delete_fieldlayoutschemeentity_" + issueTypeId);
    }

    private String getSchemeIdForName(String fieldConfigSchemeName) {
        HtmlPage page = new HtmlPage(this.tester);
        WebLink schemeLink = page.getLinksWithExactText(fieldConfigSchemeName)[0];
        return URLUtil.getQueryParamValueFromUrl(schemeLink.getURLString(), "id");
    }
}

