/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.NavigationImpl;
import com.atlassian.jira.functest.framework.admin.FieldConfigurations;
import com.atlassian.jira.functest.framework.admin.FieldScreenAssociations;
import com.atlassian.jira.functest.framework.admin.FieldScreenAssociationsImpl;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.util.JIRAEnvironmentData;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FieldConfigurationsImpl
implements FieldConfigurations,
FieldConfigurations.FieldConfiguration {
    private final WebTester tester;
    private final JIRAEnvironmentData environmentData;
    private Navigation navigation;

    @Inject
    public FieldConfigurationsImpl(WebTester tester, JIRAEnvironmentData environmentData) {
        this.tester = tester;
        this.environmentData = environmentData;
    }

    private Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = new NavigationImpl(this.tester, this.environmentData);
        }
        return this.navigation;
    }

    @Override
    public FieldConfigurations.FieldConfiguration defaultFieldConfiguration() {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-Default Field Configuration");
        return this;
    }

    @Override
    public FieldConfigurations.FieldConfiguration fieldConfiguration(String fieldConfigurationName) {
        this.getNavigation().gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-" + fieldConfigurationName);
        return this;
    }

    @Override
    public void showField(int id) {
        this.tester.clickLink("show_" + id);
    }

    @Override
    public void showFields(String name) {
        this.clickLinkForFieldWithText(name, "Show");
    }

    @Override
    public void hideField(int id) {
        this.tester.clickLink("hide_" + id);
    }

    @Override
    public void hideFields(String name) {
        this.clickLinkForFieldWithText(name, "Hide");
    }

    @Override
    public void requireField(String name) {
        this.clickLinkForFieldWithText(name, "Required");
    }

    @Override
    public void optionalField(String name) {
        this.clickLinkForFieldWithText(name, "Optional");
    }

    @Override
    public String getRenderer(String fieldName) {
        this.clickLinkForFieldWithText(fieldName, "Renderers");
        return this.tester.getDialog().getSelectedOption("selectedRendererType");
    }

    @Override
    public void setRenderer(String fieldName, String rendererName) {
        this.clickLinkForFieldWithText(fieldName, "Renderers");
        this.tester.selectOption("selectedRendererType", rendererName);
        this.tester.submit();
        try {
            if (this.tester.getDialog().getResponse().getFormWithName("jiraform") != null) {
                this.tester.setWorkingForm("jiraform");
                this.tester.submit();
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    @Override
    public FieldScreenAssociations getScreens(String name) {
        this.clickLinkForFieldWithText(name, "Screens");
        return new FieldScreenAssociationsImpl(this.tester, this.environmentData);
    }

    private void clickLinkForFieldWithText(String name, String urlText) {
        XPathLocator locator = new XPathLocator(this.tester, String.format("//table[@id = 'field_table']//a[contains(@title, \"'%s'\") and contains(text(), '%s')]/@id", name, urlText));
        Node[] nodes = locator.getNodes();
        if (nodes == null || nodes.length == 0) {
            throw new AssertionError((Object)String.format("Unable to %s field '%s': Could not find the '%s' link.", urlText, name, urlText));
        }
        for (Node node : nodes) {
            String id = node.getNodeValue();
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            this.tester.clickLink(id);
        }
    }
}

