/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.functest.framework.admin;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.IssueLinking;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.sourceforge.jwebunit.WebTester;

public class IssueLinkingImpl
implements IssueLinking {
    private final WebTester tester;
    private final Navigation navigation;
    private final FuncTestLogger logger;

    @Inject
    public IssueLinkingImpl(WebTester tester, Navigation navigation, FuncTestLogger logger) {
        this.tester = tester;
        this.navigation = navigation;
        this.logger = logger;
    }

    @Override
    public void enable() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        XPathLocator locator = new XPathLocator(this.tester, "//input[@name='Activate']");
        if (locator.getNodes().length > 0) {
            this.logger.log((Object)"Activating issue linking");
            this.tester.submit("Activate");
        } else {
            this.logger.log((Object)"Issue linking already activated");
        }
    }

    @Override
    public void disable() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        XPathLocator locator = new XPathLocator(this.tester, "//input[@name='Deactivate']");
        if (locator.getNodes().length > 0) {
            this.logger.log((Object)"Deactivating issue linking");
            this.tester.submit("Deactivate");
        } else {
            this.logger.log((Object)"Issue linking already deactivated");
        }
    }

    @Override
    public void addIssueLink(String name, String outward, String inward) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("outward", outward);
        this.tester.setFormElement("inward", inward);
        this.tester.submit("Add");
    }

    @Override
    public void delete(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        this.tester.clickLink("del_" + name);
        this.tester.submit("Delete");
    }

    @Override
    public boolean exists(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        return this.tester.getDialog().isLinkPresent("del_" + name);
    }

    @Override
    public long getLinkId(String name) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        Pattern pattern = Pattern.compile("a id=\"del_" + name + ".+?\\?id=(\\d+)");
        Matcher matcher = pattern.matcher(this.tester.getDialog().getResponseText());
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1));
        }
        throw new RuntimeException("Link not found: " + name);
    }
}

